/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easypiglins.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.easypiglins.blocks.BartererBlock;
import de.maxhenkel.easypiglins.blocks.ModBlocks;
import de.maxhenkel.easypiglins.blocks.tileentity.BartererTileentity;
import de.maxhenkel.easypiglins.corelib.client.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.PiglinRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;

public class BartererRenderer
implements BlockEntityRenderer<BartererTileentity> {
    private Minecraft minecraft;
    protected BlockEntityRendererProvider.Context context;
    private PiglinRenderer renderer;

    public BartererRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
        this.minecraft = Minecraft.getInstance();
    }

    public void render(BartererTileentity barterer, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        this.renderBlock(matrixStack, buffer, combinedLightIn, combinedOverlayIn);
        this.renderWithoutBlock(barterer, partialTicks, matrixStack, buffer, combinedLightIn, combinedOverlayIn);
    }

    public void renderWithoutBlock(BartererTileentity barterer, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        Piglin piglin;
        matrixStack.pushPose();
        this.renderBlock(matrixStack, buffer, combinedLightIn, combinedOverlayIn);
        if (this.renderer == null) {
            this.renderer = new PiglinRenderer(this.getEntityRenderer(), ModelLayers.PIGLIN, ModelLayers.PIGLIN_INNER_ARMOR, ModelLayers.PIGLIN_OUTER_ARMOR, false);
        }
        Direction direction = Direction.SOUTH;
        if (!barterer.isFakeWorld()) {
            direction = (Direction)barterer.getBlockState().getValue((Property)BartererBlock.FACING);
        }
        if ((piglin = barterer.getPiglinEntity()) != null) {
            matrixStack.pushPose();
            piglin.setItemInHand(InteractionHand.OFF_HAND, barterer.getBarteringItem());
            matrixStack.translate(0.5, 0.0625, 0.5);
            matrixStack.mulPose(Axis.YP.rotationDegrees(-direction.toYRot()));
            matrixStack.translate(0.0, 0.0, -0.25);
            matrixStack.scale(0.45f, 0.45f, 0.45f);
            this.renderer.render((Mob)piglin, 0.0f, 1.0f, matrixStack, buffer, combinedLightIn);
            matrixStack.popPose();
        }
        matrixStack.popPose();
    }

    protected void renderBlock(PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        BlockState state = ((BartererBlock)ModBlocks.BARTERER.get()).defaultBlockState();
        int color = this.minecraft.getBlockColors().getColor(state, null, null, 0);
        BlockRenderDispatcher dispatcher = this.minecraft.getBlockRenderer();
        dispatcher.getModelRenderer().renderModel(matrixStack.last(), buffer.getBuffer(RenderType.cutoutMipped()), state, dispatcher.getBlockModel(state), (float)RenderUtils.getRed(color), (float)RenderUtils.getGreen(color), (float)RenderUtils.getBlue(color), combinedLight, combinedOverlay, ModelData.EMPTY, RenderType.cutoutMipped());
    }

    public EntityRendererProvider.Context getEntityRenderer() {
        return new EntityRendererProvider.Context(this.minecraft.getEntityRenderDispatcher(), this.minecraft.getItemRenderer(), this.minecraft.getBlockRenderer(), this.minecraft.gameRenderer.itemInHandRenderer, this.minecraft.getResourceManager(), this.minecraft.getEntityModels(), this.minecraft.font);
    }
}

