/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easypiglins.corelib.dataserializers;

import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.world.item.ItemStack;

public class DataSerializerItemList {
    public static EntityDataSerializer<NonNullList<ItemStack>> create() {
        return new EntityDataSerializer<NonNullList<ItemStack>>(){

            public void write(FriendlyByteBuf packetBuffer, NonNullList<ItemStack> itemStacks) {
                packetBuffer.writeInt(itemStacks.size());
                for (ItemStack itemStack : itemStacks) {
                    packetBuffer.writeItem(itemStack);
                }
            }

            public NonNullList<ItemStack> read(FriendlyByteBuf buf) {
                int length = buf.readInt();
                NonNullList list = NonNullList.withSize((int)length, (Object)ItemStack.EMPTY);
                for (int i = 0; i < list.size(); ++i) {
                    list.set(i, (Object)buf.readItem());
                }
                return list;
            }

            public NonNullList<ItemStack> copy(NonNullList<ItemStack> itemStacks) {
                NonNullList list = NonNullList.withSize((int)itemStacks.size(), (Object)ItemStack.EMPTY);
                for (int i = 0; i < itemStacks.size(); ++i) {
                    list.set(i, (Object)((ItemStack)itemStacks.get(i)).copy());
                }
                return list;
            }
        };
    }
}

