/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easypiglins.events;

import de.maxhenkel.easypiglins.items.ModItems;
import de.maxhenkel.easypiglins.items.PiglinItem;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class PiglinEvents {
    @SubscribeEvent
    public void onClick(PlayerInteractEvent.EntityInteract event) {
        if (!(event.getTarget() instanceof Piglin)) {
            return;
        }
        Piglin piglin = (Piglin)event.getTarget();
        Player player = event.getEntity();
        if (player.level().isClientSide || !player.isShiftKeyDown() || piglin.isBaby()) {
            return;
        }
        if (!piglin.isAlive()) {
            return;
        }
        PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
        if (!PiglinAi.isWearingGold((LivingEntity)player) || !piglin.getBrain().isActive(Activity.IDLE)) {
            piglin.getBrain().setMemoryWithExpiry(MemoryModuleType.ANGRY_AT, (Object)player.getUUID(), 600L);
            player.displayClientMessage((Component)Component.translatable((String)"message.easy_piglins.cant_pick_up"), true);
            return;
        }
        ItemStack stack = new ItemStack((ItemLike)ModItems.PIGLIN.get());
        ((PiglinItem)((Object)ModItems.PIGLIN.get())).setPiglin(stack, piglin);
        if (player.getInventory().add(stack)) {
            piglin.discard();
        }
        event.setCancellationResult(InteractionResult.SUCCESS);
        event.setCanceled(true);
    }
}

