/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.visuality.config;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import plus.dragons.visuality.Visuality;
import plus.dragons.visuality.config.ReloadableJsonConfig;
import plus.dragons.visuality.data.ParticleWithVelocity;
import plus.dragons.visuality.data.VisualityCodecs;
import plus.dragons.visuality.registry.VisualityParticles;

public class BlockStepParticleConfig
extends ReloadableJsonConfig {
    private boolean enabled = true;
    private int interval = 10;
    private List<Entry> entries;
    private final IdentityHashMap<Block, ParticleWithVelocity> particles = new IdentityHashMap();

    public BlockStepParticleConfig() {
        super(Visuality.location("particle_emitters/block_step"));
        this.entries = BlockStepParticleConfig.createDefaultEntries();
        for (Entry entry : this.entries) {
            for (Block block : entry.blocks) {
                this.particles.put(block, entry.particle);
            }
        }
    }

    public int getInterval() {
        return this.interval;
    }

    public void spawnParticles(int amount, Level level, BlockState state, BlockPos pos, Entity entity) {
        if (!this.enabled || entity.isSteppingCarefully()) {
            return;
        }
        Block block = state.getBlock();
        if (!this.particles.containsKey(block)) {
            return;
        }
        ParticleWithVelocity particle = this.particles.get(block);
        double y = entity.getY() + 0.0625;
        for (int i = 0; i < amount; ++i) {
            double x = (double)pos.getX() + level.random.nextDouble();
            double z = (double)pos.getZ() + level.random.nextDouble();
            particle.spawn(level, x, y, z);
        }
    }

    @Override
    @Nullable
    protected JsonObject apply(JsonObject input, boolean config, String source, ProfilerFiller profiler) {
        JsonArray array;
        profiler.push(source);
        if (config) {
            this.enabled = GsonHelper.getAsBoolean((JsonObject)input, (String)"enabled", (boolean)true);
            this.interval = GsonHelper.getAsInt((JsonObject)input, (String)"interval", (int)10);
        }
        if ((array = GsonHelper.getAsJsonArray((JsonObject)input, (String)"entries", null)) == null) {
            this.logger.warn("Failed to load options entries from {}: Missing JsonArray 'entries'.", (Object)source);
            profiler.pop();
            return config ? this.serializeConfig() : null;
        }
        boolean save = false;
        ArrayList<Entry> newEntries = new ArrayList<Entry>();
        ArrayList elements = Lists.newArrayList((Iterable)array);
        for (JsonElement element : elements) {
            DataResult data = Entry.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
            if (data.error().isPresent()) {
                save = config;
                this.logger.warn("Error parsing {} from {}: {}", new Object[]{this.id, source, ((DataResult.PartialResult)data.error().get()).message()});
                continue;
            }
            if (data.result().isPresent()) {
                newEntries.add((Entry)data.result().get());
                continue;
            }
            save = config;
            this.logger.warn("Error parsing {} from {}: Missing decode result", (Object)this.id, (Object)source);
        }
        if (config) {
            this.entries = newEntries;
            this.particles.clear();
        }
        for (Entry entry : newEntries) {
            for (Block block : entry.blocks) {
                this.particles.put(block, entry.particle);
            }
        }
        profiler.pop();
        return save ? this.serializeConfig() : null;
    }

    @Override
    protected JsonObject serializeConfig() {
        JsonObject object = new JsonObject();
        object.addProperty("enabled", Boolean.valueOf(this.enabled));
        object.addProperty("interval", (Number)this.interval);
        object.add("entries", (JsonElement)Entry.LIST_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, this.entries).getOrThrow(true, msg -> this.logger.error("Failed to serialize config entries: {}", msg)));
        return object;
    }

    private static List<Entry> createDefaultEntries() {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        entries.add(Entry.of((ParticleOptions)VisualityParticles.SOUL.get(), Blocks.SOUL_SAND, Blocks.SOUL_SOIL));
        return entries;
    }

    private record Entry(List<Block> blocks, ParticleWithVelocity particle) {
        private static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VisualityCodecs.compressedListOf(BuiltInRegistries.BLOCK.byNameCodec()).fieldOf("block").forGetter(Entry::blocks), (App)ParticleWithVelocity.CODEC.fieldOf("particle").forGetter(Entry::particle)).apply((Applicative)instance, Entry::new));
        private static final Codec<List<Entry>> LIST_CODEC = CODEC.listOf();

        static Entry of(ParticleOptions particle, Block ... blocks) {
            return new Entry(List.of(blocks), ParticleWithVelocity.ofZeroVelocity(particle));
        }
    }
}

