/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.visuality.particle.type;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;

public class ColorParticleType
extends ParticleType<Options> {
    private final Codec<Options> codec = Codec.FLOAT.listOf().comapFlatMap(floats -> Util.fixedSize((List)floats, (int)3).map(it -> new Options(((Float)it.get(0)).floatValue(), ((Float)it.get(1)).floatValue(), ((Float)it.get(2)).floatValue())), options -> ImmutableList.of((Object)Float.valueOf(options.r), (Object)Float.valueOf(options.g), (Object)Float.valueOf(options.b)));

    public ColorParticleType(boolean overrideLimiter) {
        super(overrideLimiter, (ParticleOptions.Deserializer)Deserializer.INSTANCE);
    }

    public ColorParticleType() {
        this(false);
    }

    public Codec<Options> codec() {
        return this.codec;
    }

    public Options withColor(float r, float g, float b) {
        return new Options(r, g, b);
    }

    public Options withColor(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return new Options(r, g, b);
    }

    public static enum Deserializer implements ParticleOptions.Deserializer<Options>
    {
        INSTANCE;


        public Options fromCommand(ParticleType<Options> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float r = reader.readFloat();
            reader.expect(' ');
            float g = reader.readFloat();
            reader.expect(' ');
            float b = reader.readFloat();
            return ((ColorParticleType)type).withColor(r, g, b);
        }

        public Options fromNetwork(ParticleType<Options> type, FriendlyByteBuf buffer) {
            ColorParticleType colorParticleType = (ColorParticleType)type;
            Objects.requireNonNull(colorParticleType);
            return colorParticleType.new Options(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    }

    public class Options
    implements ParticleOptions {
        public final float r;
        public final float g;
        public final float b;

        private Options(float r, float g, float b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public ParticleType<?> getType() {
            return ColorParticleType.this;
        }

        public void writeToNetwork(FriendlyByteBuf buffer) {
            buffer.writeFloat(this.r);
            buffer.writeFloat(this.g);
            buffer.writeFloat(this.b);
        }

        public String writeToString() {
            return String.format(Locale.ROOT, "%s %.2f %.2f %.2f", BuiltInRegistries.PARTICLE_TYPE.getKey(this.getType()), Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b));
        }
    }
}

