/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.block;

import com.mrbysco.enchantableblocks.block.blockentity.EnchantedBedBlockEntity;
import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.registry.ModEnchantments;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class EnchantedBedBlock
extends BedBlock {
    private final Supplier<Block> originalBlock;

    public EnchantedBedBlock(DyeColor dyeColor, Supplier<Block> originalBlock, BlockBehaviour.Properties properties) {
        super(dyeColor, properties);
        this.originalBlock = originalBlock;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new EnchantedBedBlockEntity(pos, state);
    }

    public Item asItem() {
        return this.originalBlock.get().asItem();
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        IEnchantable blockEntity;
        ItemStack originalStack = new ItemStack((ItemLike)this.originalBlock.get());
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof IEnchantable && (blockEntity = (IEnchantable)blockEntity2).getEnchantmentsTag() != null) {
            originalStack.getOrCreateTag().put("Enchantments", (Tag)blockEntity.getEnchantmentsTag());
        }
        return originalStack;
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.CONSUME;
        }
        if (state.getValue((Property)PART) != BedPart.HEAD && !(state = level.getBlockState(pos = pos.relative((Direction)state.getValue((Property)FACING)))).is((Block)this)) {
            return InteractionResult.CONSUME;
        }
        boolean explodes = false;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IEnchantable) {
            IEnchantable enchantable = (IEnchantable)blockEntity;
            explodes = enchantable.hasEnchantment((Enchantment)ModEnchantments.INTENTIONAL_GAME_DESIGN.get());
        }
        if (!EnchantedBedBlock.canSetSpawn((Level)level) || explodes) {
            level.removeBlock(pos, false);
            BlockPos blockpos = pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite());
            if (level.getBlockState(blockpos).is((Block)this)) {
                level.removeBlock(blockpos, false);
            }
            Vec3 vec3 = pos.getCenter();
            level.explode((Entity)null, level.damageSources().badRespawnPointExplosion(vec3), (ExplosionDamageCalculator)null, vec3, 5.0f, true, Level.ExplosionInteraction.BLOCK);
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.getValue((Property)OCCUPIED)).booleanValue()) {
            if (!this.kickVillagerOutOfBed(level, pos)) {
                player.displayClientMessage((Component)Component.translatable((String)"block.minecraft.bed.occupied"), true);
            }
            return InteractionResult.SUCCESS;
        }
        player.startSleepInBed(pos).ifLeft(problem -> {
            if (problem.getMessage() != null) {
                player.displayClientMessage(problem.getMessage(), true);
            }
        });
        return InteractionResult.SUCCESS;
    }

    private boolean kickVillagerOutOfBed(Level level, BlockPos pos) {
        List villagers = level.getEntitiesOfClass(Villager.class, new AABB(pos), LivingEntity::isSleeping);
        if (villagers.isEmpty()) {
            return false;
        }
        ((Villager)villagers.get(0)).stopSleeping();
        return true;
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        IEnchantable enchantable;
        float explosionResistance = super.getExplosionResistance(state, level, pos, explosion);
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof IEnchantable && (enchantable = (IEnchantable)blockentity).hasEnchantment(Enchantments.BLAST_PROTECTION)) {
            int enchantmentLevel = enchantable.getEnchantmentLevel(Enchantments.BLAST_PROTECTION);
            explosionResistance *= (float)((enchantmentLevel + 1) * 30);
        }
        return explosionResistance;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        IEnchantable enchantable;
        BlockEntity blockentity = (BlockEntity)params.getParameter(LootContextParams.BLOCK_ENTITY);
        if (blockentity instanceof IEnchantable && (enchantable = (IEnchantable)blockentity).hasEnchantment(Enchantments.VANISHING_CURSE)) {
            return List.of();
        }
        return super.getDrops(state, params);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (!level.isClientSide && blockentity instanceof IEnchantable) {
            IEnchantable enchantable = (IEnchantable)blockentity;
            enchantable.setEnchantments(stack.getEnchantmentTags());
        }
        BlockPos blockpos = pos.relative((Direction)state.getValue((Property)FACING));
        BlockEntity blockentity2 = level.getBlockEntity(blockpos);
        if (!level.isClientSide && blockentity2 instanceof IEnchantable) {
            IEnchantable enchantable = (IEnchantable)blockentity2;
            enchantable.setEnchantments(stack.getEnchantmentTags());
        }
    }
}

