/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.block;

import com.mrbysco.enchantableblocks.block.blockentity.EnchantedCampfireBlockEntity;
import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.registry.ModEnchantments;
import com.mrbysco.enchantableblocks.registry.ModRegistry;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;

public class EnchantedCampfireBlock
extends CampfireBlock {
    private final Supplier<Block> originalBlock;

    public EnchantedCampfireBlock(boolean spawnParticles, int fireDamage, Supplier<Block> originalBlock, BlockBehaviour.Properties properties) {
        super(spawnParticles, fireDamage, properties);
        this.originalBlock = originalBlock;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new EnchantedCampfireBlockEntity(pos, state);
    }

    public Item asItem() {
        return this.originalBlock.get().asItem();
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide) {
            return (Boolean)state.getValue((Property)LIT) != false ? EnchantedCampfireBlock.createTickerHelper(blockEntityType, ModRegistry.ENCHANTED_CAMPFIRE_BLOCK_ENTITY.get(), EnchantedCampfireBlockEntity::particleTick) : null;
        }
        return (Boolean)state.getValue((Property)LIT) != false ? EnchantedCampfireBlock.createTickerHelper(blockEntityType, ModRegistry.ENCHANTED_CAMPFIRE_BLOCK_ENTITY.get(), EnchantedCampfireBlockEntity::cookTick) : EnchantedCampfireBlock.createTickerHelper(blockEntityType, ModRegistry.ENCHANTED_CAMPFIRE_BLOCK_ENTITY.get(), EnchantedCampfireBlockEntity::cooldownTick);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue() && entity instanceof LivingEntity && !EnchantmentHelper.hasFrostWalker((LivingEntity)((LivingEntity)entity))) {
            IEnchantable enchantable;
            float damage = this.fireDamage;
            BlockEntity blockentity = level.getBlockEntity(pos);
            if (blockentity instanceof IEnchantable && (enchantable = (IEnchantable)blockentity).hasEnchantment((Enchantment)ModEnchantments.BOILING.get())) {
                int enchantmentLevel = enchantable.getEnchantmentLevel((Enchantment)ModEnchantments.BOILING.get());
                damage *= (float)(enchantmentLevel + 1);
            }
            entity.hurt(level.damageSources().inFire(), damage);
        }
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        IEnchantable blockEntity;
        ItemStack originalStack = new ItemStack((ItemLike)this.originalBlock.get());
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof IEnchantable && (blockEntity = (IEnchantable)blockEntity2).getEnchantmentsTag() != null) {
            originalStack.getOrCreateTag().put("Enchantments", (Tag)blockEntity.getEnchantmentsTag());
        }
        return originalStack;
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        IEnchantable enchantable;
        float explosionResistance = super.getExplosionResistance(state, level, pos, explosion);
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof IEnchantable && (enchantable = (IEnchantable)blockentity).hasEnchantment(Enchantments.BLAST_PROTECTION)) {
            int enchantmentLevel = enchantable.getEnchantmentLevel(Enchantments.BLAST_PROTECTION);
            explosionResistance *= (float)((enchantmentLevel + 1) * 30);
        }
        return explosionResistance;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            EnchantedCampfireBlockEntity campfireBlockEntity;
            BlockEntity blockentity = level.getBlockEntity(pos);
            if (blockentity instanceof EnchantedCampfireBlockEntity && !(campfireBlockEntity = (EnchantedCampfireBlockEntity)blockentity).hasEnchantment(Enchantments.VANISHING_CURSE)) {
                Containers.dropContents((Level)level, (BlockPos)pos, (NonNullList)campfireBlockEntity.getItems());
            }
            if (!(!state.hasBlockEntity() || state.is(newState.getBlock()) && newState.hasBlockEntity())) {
                level.removeBlockEntity(pos);
            }
        }
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        IEnchantable enchantable;
        BlockEntity blockentity = (BlockEntity)params.getParameter(LootContextParams.BLOCK_ENTITY);
        if (blockentity instanceof IEnchantable && (enchantable = (IEnchantable)blockentity).hasEnchantment(Enchantments.VANISHING_CURSE)) {
            return List.of();
        }
        return super.getDrops(state, params);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource prandom) {
        IEnchantable enchantable;
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof IEnchantable && !(enchantable = (IEnchantable)blockentity).hasEnchantment((Enchantment)ModEnchantments.CONCEALED.get())) {
            super.animateTick(state, level, pos, prandom);
        }
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof IEnchantable) {
            IEnchantable enchantable = (IEnchantable)blockentity;
            enchantable.setEnchantments(stack.getEnchantmentTags());
        }
    }
}

