/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.block;

import com.mrbysco.enchantableblocks.block.blockentity.EnchantedHopperBlockEntity;
import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.registry.ModRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;

public class EnchantedHopperBlock
extends HopperBlock {
    public EnchantedHopperBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new EnchantedHopperBlockEntity(pos, state);
    }

    public Item asItem() {
        return Items.HOPPER;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        IEnchantable blockEntity;
        ItemStack originalStack = new ItemStack((ItemLike)Blocks.HOPPER);
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof IEnchantable && (blockEntity = (IEnchantable)blockEntity2).getEnchantmentsTag() != null) {
            originalStack.getOrCreateTag().put("Enchantments", (Tag)blockEntity.getEnchantmentsTag());
        }
        return originalStack;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : EnchantedHopperBlock.createTickerHelper(blockEntityType, ModRegistry.ENCHANTED_HOPPER_BLOCK_ENTITY.get(), EnchantedHopperBlockEntity::pushItemsTick);
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        IEnchantable enchantable;
        float explosionResistance = super.getExplosionResistance(state, level, pos, explosion);
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof IEnchantable && (enchantable = (IEnchantable)blockentity).hasEnchantment(Enchantments.BLAST_PROTECTION)) {
            int enchantmentLevel = enchantable.getEnchantmentLevel(Enchantments.BLAST_PROTECTION);
            explosionResistance *= (float)((enchantmentLevel + 1) * 30);
        }
        return explosionResistance;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            EnchantedHopperBlockEntity hopperBlockEntity;
            BlockEntity blockentity = level.getBlockEntity(pos);
            if (blockentity instanceof EnchantedHopperBlockEntity && !(hopperBlockEntity = (EnchantedHopperBlockEntity)blockentity).hasEnchantment(Enchantments.VANISHING_CURSE)) {
                Containers.dropContents((Level)level, (BlockPos)pos, (Container)hopperBlockEntity);
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            if (!(!state.hasBlockEntity() || state.is(newState.getBlock()) && newState.hasBlockEntity())) {
                level.removeBlockEntity(pos);
            }
        }
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        IEnchantable enchantable;
        BlockEntity blockentity = (BlockEntity)params.getParameter(LootContextParams.BLOCK_ENTITY);
        if (blockentity instanceof IEnchantable && (enchantable = (IEnchantable)blockentity).hasEnchantment(Enchantments.VANISHING_CURSE)) {
            return List.of();
        }
        return super.getDrops(state, params);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof IEnchantable) {
            IEnchantable enchantable = (IEnchantable)blockentity;
            enchantable.setEnchantments(stack.getEnchantmentTags());
        }
    }
}

