/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.block;

import com.mrbysco.enchantableblocks.block.blockentity.EnchantedBlockEntity;
import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.registry.ModEnchantments;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.MagmaBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;

public class EnchantedMagmaBlock
extends MagmaBlock
implements EntityBlock {
    public EnchantedMagmaBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new EnchantedBlockEntity(pos, state);
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        IEnchantable enchantable;
        float damage = 1.0f;
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof IEnchantable && (enchantable = (IEnchantable)blockentity).hasEnchantment((Enchantment)ModEnchantments.BOILING.get())) {
            int enchantmentLevel = enchantable.getEnchantmentLevel((Enchantment)ModEnchantments.BOILING.get());
            damage *= (float)(enchantmentLevel + 1);
        }
        if (!entity.isSteppingCarefully() && entity instanceof LivingEntity && !EnchantmentHelper.hasFrostWalker((LivingEntity)((LivingEntity)entity))) {
            entity.hurt(level.damageSources().hotFloor(), damage);
        }
        super.stepOn(level, pos, state, entity);
    }

    public Item asItem() {
        return Items.MAGMA_BLOCK;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        IEnchantable blockEntity;
        ItemStack originalStack = new ItemStack((ItemLike)Blocks.MAGMA_BLOCK);
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof IEnchantable && (blockEntity = (IEnchantable)blockEntity2).getEnchantmentsTag() != null) {
            originalStack.getOrCreateTag().put("Enchantments", (Tag)blockEntity.getEnchantmentsTag());
        }
        return originalStack;
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        IEnchantable enchantable;
        float explosionResistance = super.getExplosionResistance(state, level, pos, explosion);
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof IEnchantable && (enchantable = (IEnchantable)blockentity).hasEnchantment(Enchantments.BLAST_PROTECTION)) {
            int enchantmentLevel = enchantable.getEnchantmentLevel(Enchantments.BLAST_PROTECTION);
            explosionResistance *= (float)((enchantmentLevel + 1) * 30);
        }
        return explosionResistance;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        IEnchantable enchantable;
        BlockEntity blockentity = (BlockEntity)params.getParameter(LootContextParams.BLOCK_ENTITY);
        if (blockentity instanceof IEnchantable && (enchantable = (IEnchantable)blockentity).hasEnchantment(Enchantments.VANISHING_CURSE)) {
            return List.of();
        }
        return super.getDrops(state, params);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof IEnchantable) {
            IEnchantable enchantable = (IEnchantable)blockentity;
            enchantable.setEnchantments(stack.getEnchantmentTags());
        }
    }
}

