/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.block.blockentity;

import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.mixin.ConduitBlockEntityAccessor;
import com.mrbysco.enchantableblocks.registry.ModEnchantments;
import com.mrbysco.enchantableblocks.registry.ModRegistry;
import com.mrbysco.enchantableblocks.util.TagHelper;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ConduitBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EnchantedConduitBlockEntity
extends ConduitBlockEntity
implements IEnchantable {
    protected boolean hideGlint = false;
    protected ListTag enchantmentTag = null;
    protected final Object2IntMap<Enchantment> enchantments = new Object2IntOpenHashMap();

    public EnchantedConduitBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, EnchantedConduitBlockEntity blockEntity) {
        ++blockEntity.tickCount;
        long i = level.getGameTime();
        List effectBlocks = blockEntity.effectBlocks;
        if (i % 40L == 0L) {
            boolean flag = ConduitBlockEntityAccessor.invokeUpdateShape(level, pos, effectBlocks);
            if (flag != blockEntity.isActive) {
                SoundEvent soundevent = flag ? SoundEvents.CONDUIT_ACTIVATE : SoundEvents.CONDUIT_DEACTIVATE;
                level.playSound((Player)null, pos, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            blockEntity.isActive = flag;
            ConduitBlockEntityAccessor.invokeUpdateHunting(blockEntity, effectBlocks);
            if (flag) {
                EnchantedConduitBlockEntity.applyEffects(level, pos, effectBlocks, blockEntity);
                EnchantedConduitBlockEntity.updateDestroyTarget(level, pos, state, effectBlocks, blockEntity);
            }
        }
        if (blockEntity.isActive()) {
            if (i % 80L == 0L) {
                level.playSound((Player)null, pos, SoundEvents.CONDUIT_AMBIENT, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (i > blockEntity.nextAmbientSoundActivation) {
                blockEntity.nextAmbientSoundActivation = i + 60L + (long)level.getRandom().nextInt(40);
                level.playSound((Player)null, pos, SoundEvents.CONDUIT_AMBIENT_SHORT, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    private static void applyEffects(Level level, BlockPos pos, List<BlockPos> positions, EnchantedConduitBlockEntity blockEntity) {
        int zPos;
        int yPos;
        int xPos;
        AABB aabb;
        List players;
        boolean concealed = blockEntity.hasEnchantment((Enchantment)ModEnchantments.CONCEALED.get());
        int blockCount = positions.size();
        int range = blockCount / 7 * 16;
        if (blockEntity.hasEnchantment((Enchantment)ModEnchantments.RANGED.get())) {
            int enchantmentLevel = blockEntity.getEnchantmentLevel((Enchantment)ModEnchantments.RANGED.get());
            range *= (int)(1.0 + (double)enchantmentLevel * 0.5);
        }
        if (!(players = level.getEntitiesOfClass(Player.class, aabb = new AABB((double)(xPos = pos.getX()), (double)(yPos = pos.getY()), (double)(zPos = pos.getZ()), (double)(xPos + 1), (double)(yPos + 1), (double)(zPos + 1)).inflate((double)range).expandTowards(0.0, (double)level.getHeight(), 0.0))).isEmpty()) {
            for (Player player : players) {
                if (!pos.closerThan((Vec3i)player.blockPosition(), (double)range) || !player.isInWaterOrRain()) continue;
                player.addEffect(new MobEffectInstance(MobEffects.CONDUIT_POWER, 260, 0, true, !concealed));
            }
        }
    }

    private static void updateDestroyTarget(Level level, BlockPos pos, BlockState state, List<BlockPos> positions, EnchantedConduitBlockEntity blockEntity) {
        LivingEntity livingentity = blockEntity.destroyTarget;
        int blockCount = positions.size();
        if (blockCount < 42) {
            blockEntity.destroyTarget = null;
        } else if (blockEntity.destroyTarget == null && blockEntity.destroyTargetUUID != null) {
            blockEntity.destroyTarget = ConduitBlockEntityAccessor.invokeFindDestroyTarget(level, pos, blockEntity.destroyTargetUUID);
            blockEntity.destroyTargetUUID = null;
        } else if (blockEntity.destroyTarget == null) {
            List list = level.getEntitiesOfClass(LivingEntity.class, ConduitBlockEntityAccessor.invokeGetDestroyRangeAABB(pos), livingEntity -> livingEntity instanceof Enemy && livingEntity.isInWaterOrRain());
            if (!list.isEmpty()) {
                blockEntity.destroyTarget = (LivingEntity)list.get(level.random.nextInt(list.size()));
            }
        } else if (!blockEntity.destroyTarget.isAlive() || !pos.closerThan((Vec3i)blockEntity.destroyTarget.blockPosition(), 8.0)) {
            blockEntity.destroyTarget = null;
        }
        if (blockEntity.destroyTarget != null) {
            level.playSound((Player)null, blockEntity.destroyTarget.getX(), blockEntity.destroyTarget.getY(), blockEntity.destroyTarget.getZ(), SoundEvents.CONDUIT_ATTACK_TARGET, SoundSource.BLOCKS, 1.0f, 1.0f);
            float damage = 4.0f;
            if (blockEntity.hasEnchantment(Enchantments.SHARPNESS)) {
                int enchantmentLevel = blockEntity.getEnchantmentLevel(Enchantments.SHARPNESS);
                damage += 1.0f + (float)Math.max(0, enchantmentLevel - 1) * 0.5f;
            }
            blockEntity.destroyTarget.hurt(level.damageSources().magic(), damage);
        }
        if (livingentity != blockEntity.destroyTarget) {
            level.sendBlockUpdated(pos, state, state, 2);
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, EnchantedConduitBlockEntity blockEntity) {
        ++blockEntity.tickCount;
        long i = level.getGameTime();
        List list = blockEntity.effectBlocks;
        if (i % 40L == 0L) {
            blockEntity.isActive = ConduitBlockEntityAccessor.invokeUpdateShape(level, pos, list);
            ConduitBlockEntityAccessor.invokeUpdateHunting(blockEntity, list);
        }
        ConduitBlockEntityAccessor.invokeUpdateClientTarget(level, pos, blockEntity);
        EnchantedConduitBlockEntity.animationTick(blockEntity, level, pos, list, (Entity)blockEntity.destroyTarget, blockEntity.tickCount);
        if (blockEntity.isActive()) {
            blockEntity.activeRotation += 1.0f;
        }
    }

    private static void animationTick(EnchantedConduitBlockEntity blockEntity, Level level, BlockPos pos, List<BlockPos> positions, @Nullable Entity entity, int tickCount) {
        if (blockEntity.hasEnchantment((Enchantment)ModEnchantments.CONCEALED.get())) {
            return;
        }
        RandomSource random = level.random;
        double d0 = Mth.sin((float)((float)(tickCount + 35) * 0.1f)) / 2.0f + 0.5f;
        d0 = (d0 * d0 + d0) * (double)0.3f;
        Vec3 vec3 = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 1.5 + d0, (double)pos.getZ() + 0.5);
        for (BlockPos blockpos : positions) {
            if (random.nextInt(50) != 0) continue;
            BlockPos subtractPos = blockpos.subtract((Vec3i)pos);
            float f = -0.5f + random.nextFloat() + (float)subtractPos.getX();
            float f1 = -2.0f + random.nextFloat() + (float)subtractPos.getY();
            float f2 = -0.5f + random.nextFloat() + (float)subtractPos.getZ();
            level.addParticle((ParticleOptions)ParticleTypes.NAUTILUS, vec3.x, vec3.y, vec3.z, (double)f, (double)f1, (double)f2);
        }
        if (entity != null) {
            Vec3 eyePos = new Vec3(entity.getX(), entity.getEyeY(), entity.getZ());
            float f3 = (-0.5f + random.nextFloat()) * (3.0f + entity.getBbWidth());
            float f4 = -1.0f + random.nextFloat() * entity.getBbHeight();
            float f5 = (-0.5f + random.nextFloat()) * (3.0f + entity.getBbWidth());
            Vec3 vec32 = new Vec3((double)f3, (double)f4, (double)f5);
            level.addParticle((ParticleOptions)ParticleTypes.NAUTILUS, eyePos.x, eyePos.y, eyePos.z, vec32.x, vec32.y, vec32.z);
        }
    }

    public BlockEntityType<?> getType() {
        return ModRegistry.ENCHANTED_CONDUIT_BLOCK_ENTITY.get();
    }

    @Override
    public Map<Enchantment, Integer> getEnchantments() {
        return this.enchantments;
    }

    @Override
    public boolean hasEnchantment(Enchantment enchantment) {
        return this.enchantments.containsKey((Object)enchantment);
    }

    @Override
    public int getEnchantmentLevel(Enchantment enchantment) {
        if (this.hasEnchantment(enchantment)) {
            return this.enchantments.get((Object)enchantment);
        }
        return -1;
    }

    @Override
    public boolean hasEnchantment(TagKey<Enchantment> enchantmentTag) {
        for (Enchantment enchantment : this.enchantments.keySet()) {
            if (!TagHelper.matchesTag(enchantment, enchantmentTag)) continue;
            return true;
        }
        return this.enchantments.containsKey(enchantmentTag);
    }

    @Override
    public int getEnchantmentLevel(TagKey<Enchantment> enchantmentTag) {
        for (Enchantment enchantment : this.enchantments.keySet()) {
            if (!TagHelper.matchesTag(enchantment, enchantmentTag)) continue;
            return this.enchantments.get((Object)enchantment);
        }
        return -1;
    }

    @Override
    public void setEnchantments(ListTag enchantmentTags) {
        this.enchantmentTag = enchantmentTags;
        this.updateEnchantmentMap();
    }

    @Override
    public ListTag getEnchantmentsTag() {
        return this.enchantmentTag;
    }

    @Override
    public void updateEnchantmentMap() {
        this.enchantments.clear();
        if (this.enchantmentTag != null) {
            EnchantmentHelper.deserializeEnchantments((ListTag)this.enchantmentTag).forEach((enchantment, integer) -> {
                if (enchantment != null) {
                    this.enchantments.put(enchantment, integer);
                }
            });
            this.hideGlint = this.hasEnchantment((Enchantment)ModEnchantments.GLINTLESS.get());
        }
    }

    @Override
    public boolean hideGlint() {
        return this.hideGlint;
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        if (tag.contains("Enchantments")) {
            this.enchantmentTag = tag.getList("Enchantments", 10);
            this.updateEnchantmentMap();
        }
    }

    protected void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        if (this.enchantmentTag != null) {
            tag.put("Enchantments", (Tag)this.enchantmentTag);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        CompoundTag tag = packet.getTag();
        if (tag != null) {
            this.handleUpdateTag(tag);
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    public CompoundTag getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.load(tag);
    }

    public CompoundTag getPersistentData() {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag);
        return tag;
    }
}

