/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.block.blockentity.furnace;

import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.mixin.AbstractFurnaceBlockEntityAccessor;
import com.mrbysco.enchantableblocks.registry.ModEnchantments;
import com.mrbysco.enchantableblocks.registry.ModTags;
import com.mrbysco.enchantableblocks.util.TagHelper;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEnchantedFurnaceBlockEntity
extends AbstractFurnaceBlockEntity
implements IEnchantable {
    protected boolean hideGlint = false;
    protected ListTag enchantmentTag = null;
    protected final Object2IntMap<Enchantment> enchantments = new Object2IntOpenHashMap();

    protected AbstractEnchantedFurnaceBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state, RecipeType<? extends AbstractCookingRecipe> recipeType) {
        super(blockEntityType, pos, state, recipeType);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AbstractEnchantedFurnaceBlockEntity blockEntity) {
        ItemStack fuel;
        boolean hasFuel;
        RecipeHolder recipe;
        boolean solarRequirements;
        AbstractFurnaceBlockEntityAccessor blockEntityAccessor = (AbstractFurnaceBlockEntityAccessor)((Object)blockEntity);
        RecipeManager.CachedCheck<Container, ? extends AbstractCookingRecipe> quickCheck = blockEntityAccessor.getQuickCheck();
        boolean wasLit = blockEntity.isLit();
        boolean changed = false;
        boolean hasInput = !((ItemStack)blockEntity.items.get(0)).isEmpty();
        boolean solar = blockEntity.hasEnchantment((Enchantment)ModEnchantments.SOLAR_RADIANCE.get());
        boolean bl = solarRequirements = level.isDay() && level.canSeeSky(pos.above());
        if (blockEntity.isLit()) {
            int speed = blockEntity.getSpeed();
            if (solar) {
                blockEntity.litTime = solarRequirements ? 200 : (blockEntity.litTime -= speed);
            } else {
                boolean preservation = blockEntity.hasEnchantment((Enchantment)ModEnchantments.PRESERVATION.get());
                if (preservation) {
                    RecipeHolder recipeHolder = recipe = hasInput ? (RecipeHolder)quickCheck.getRecipeFor((Container)blockEntity, level).orElse(null) : null;
                    if (recipe != null) {
                        blockEntity.litTime -= speed;
                    }
                } else {
                    blockEntity.litTime -= speed;
                }
            }
        }
        boolean bl2 = hasFuel = !(fuel = (ItemStack)blockEntity.items.get(1)).isEmpty();
        if (blockEntity.isLit() || (solar && solarRequirements || hasFuel) && hasInput) {
            recipe = hasInput ? (RecipeHolder)quickCheck.getRecipeFor((Container)blockEntity, level).orElse(null) : null;
            int i = blockEntity.getMaxStackSize();
            if (!blockEntity.isLit()) {
                if (solar && solarRequirements) {
                    blockEntity.litDuration = blockEntity.litTime = 200;
                } else if (blockEntityAccessor.invokeCanBurn(level.registryAccess(), recipe, (NonNullList<ItemStack>)blockEntity.items, i)) {
                    blockEntity.litDuration = blockEntity.litTime = blockEntity.getBurnDuration(fuel);
                    if (blockEntity.isLit()) {
                        changed = true;
                        if (fuel.hasCraftingRemainingItem()) {
                            blockEntity.items.set(1, (Object)fuel.getCraftingRemainingItem());
                        } else if (hasFuel) {
                            fuel.shrink(1);
                            if (fuel.isEmpty()) {
                                blockEntity.items.set(1, (Object)fuel.getCraftingRemainingItem());
                            }
                        }
                    }
                }
            }
            if (blockEntity.isLit() && blockEntityAccessor.invokeCanBurn(level.registryAccess(), recipe, (NonNullList<ItemStack>)blockEntity.items, i)) {
                int speed = blockEntity.getSpeed();
                blockEntity.cookingProgress += speed;
                if (blockEntity.cookingProgress >= blockEntity.cookingTotalTime) {
                    blockEntity.cookingProgress = 0;
                    blockEntity.cookingTotalTime = AbstractEnchantedFurnaceBlockEntity.getTotalCookTime(level, blockEntity);
                    if (blockEntity.enchantedBurn(level.registryAccess(), recipe, (NonNullList<ItemStack>)blockEntity.items, i)) {
                        blockEntity.setRecipeUsed(recipe);
                    }
                    changed = true;
                }
            } else {
                blockEntity.cookingProgress = 0;
            }
        } else if (!blockEntity.isLit() && blockEntity.cookingProgress > 0) {
            blockEntity.cookingProgress = Mth.clamp((int)(blockEntity.cookingProgress - 2), (int)0, (int)blockEntity.cookingTotalTime);
        }
        if (wasLit != blockEntity.isLit()) {
            changed = true;
            state = (BlockState)state.setValue((Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(blockEntity.isLit()));
            level.setBlock(pos, state, 3);
        }
        if (changed) {
            AbstractEnchantedFurnaceBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private int getSpeed() {
        int speed = 1;
        if (this.hasEnchantment((Enchantment)ModEnchantments.SPEED.get())) {
            int enchantmentLevel = this.getEnchantmentLevel((Enchantment)ModEnchantments.SPEED.get());
            speed += enchantmentLevel;
        }
        return speed;
    }

    private boolean enchantedBurn(RegistryAccess registryAccess, @Nullable RecipeHolder<?> recipeHolder, NonNullList<ItemStack> inventory, int maxStackSize) {
        if (recipeHolder != null && ((AbstractFurnaceBlockEntityAccessor)((Object)this)).invokeCanBurn(registryAccess, recipeHolder, inventory, maxStackSize)) {
            ItemStack inputStack = (ItemStack)inventory.get(0);
            ItemStack craftedStack = recipeHolder.value().assemble((Container)this, registryAccess);
            if (this.hasEnchantment((Enchantment)ModEnchantments.YIELD.get()) && craftedStack.getCount() < craftedStack.getMaxStackSize() && !craftedStack.is(ModTags.Items.YIELD_BLACKLIST)) {
                int enchantmentLevel = this.getEnchantmentLevel((Enchantment)ModEnchantments.YIELD.get());
                int count = 1 + enchantmentLevel;
                craftedStack.setCount(Mth.clamp((int)count, (int)1, (int)craftedStack.getMaxStackSize()));
            }
            ItemStack resultStack = (ItemStack)inventory.get(2);
            if (this.hasEnchantment((Enchantment)ModEnchantments.EXPORTING.get()) && this.getBlockState() != null) {
                IItemHandler itemHandler;
                BlockEntity blockEntity;
                Direction direction = (Direction)this.getBlockState().getValue((Property)AbstractFurnaceBlock.FACING);
                BlockPos leftPos = this.getBlockPos().relative(direction.getClockWise());
                BlockPos rightPos = this.getBlockPos().relative(direction.getCounterClockWise());
                if (this.level.isLoaded(leftPos) && (blockEntity = this.level.getBlockEntity(leftPos)) != null && (itemHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, leftPos, (Object)direction.getCounterClockWise())) != null) {
                    craftedStack = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)craftedStack, (boolean)false);
                }
                if (this.level.isLoaded(rightPos) && (blockEntity = this.level.getBlockEntity(rightPos)) != null && (itemHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, rightPos, (Object)direction.getClockWise())) != null) {
                    craftedStack = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)craftedStack, (boolean)false);
                }
            }
            if (resultStack.isEmpty()) {
                inventory.set(2, (Object)craftedStack.copy());
            } else if (resultStack.is(craftedStack.getItem())) {
                resultStack.grow(craftedStack.getCount());
            }
            if (inputStack.is(Blocks.WET_SPONGE.asItem()) && !((ItemStack)inventory.get(1)).isEmpty() && ((ItemStack)inventory.get(1)).is(Items.BUCKET)) {
                inventory.set(1, (Object)new ItemStack((ItemLike)Items.WATER_BUCKET));
            }
            inputStack.shrink(1);
            return true;
        }
        return false;
    }

    private static int getTotalCookTime(Level level, AbstractEnchantedFurnaceBlockEntity blockEntity) {
        AbstractFurnaceBlockEntityAccessor blockEntityAccessor = (AbstractFurnaceBlockEntityAccessor)((Object)blockEntity);
        int cookTime = blockEntityAccessor.getQuickCheck().getRecipeFor((Container)blockEntity, level).map(recipeHolder -> ((AbstractCookingRecipe)recipeHolder.value()).getCookingTime()).orElse(200);
        if (blockEntity.hasEnchantment((Enchantment)ModEnchantments.SPEED.get())) {
            int n = blockEntity.getEnchantmentLevel((Enchantment)ModEnchantments.SPEED.get());
        }
        return cookTime;
    }

    protected int getBurnDuration(ItemStack fuel) {
        int burnDuration = super.getBurnDuration(fuel);
        if (burnDuration != 0 && this.hasEnchantment((Enchantment)ModEnchantments.FUEL_EFFICIENCY.get())) {
            int enchantmentLevel = this.getEnchantmentLevel((Enchantment)ModEnchantments.FUEL_EFFICIENCY.get());
            burnDuration = Mth.ceil((float)((float)burnDuration * (1.0f + (float)enchantmentLevel * 0.2f)));
        }
        return burnDuration;
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    @Override
    public Map<Enchantment, Integer> getEnchantments() {
        return this.enchantments;
    }

    @Override
    public boolean hasEnchantment(Enchantment enchantment) {
        return this.enchantments.containsKey((Object)enchantment);
    }

    @Override
    public int getEnchantmentLevel(Enchantment enchantment) {
        if (this.hasEnchantment(enchantment)) {
            return this.enchantments.get((Object)enchantment);
        }
        return -1;
    }

    @Override
    public boolean hasEnchantment(TagKey<Enchantment> enchantmentTag) {
        for (Enchantment enchantment : this.enchantments.keySet()) {
            if (!TagHelper.matchesTag(enchantment, enchantmentTag)) continue;
            return true;
        }
        return this.enchantments.containsKey(enchantmentTag);
    }

    @Override
    public int getEnchantmentLevel(TagKey<Enchantment> enchantmentTag) {
        for (Enchantment enchantment : this.enchantments.keySet()) {
            if (!TagHelper.matchesTag(enchantment, enchantmentTag)) continue;
            return this.enchantments.get((Object)enchantment);
        }
        return -1;
    }

    @Override
    public void setEnchantments(ListTag enchantmentTags) {
        this.enchantmentTag = enchantmentTags;
        this.updateEnchantmentMap();
    }

    @Override
    public ListTag getEnchantmentsTag() {
        return this.enchantmentTag;
    }

    @Override
    public void updateEnchantmentMap() {
        this.enchantments.clear();
        if (this.enchantmentTag != null) {
            EnchantmentHelper.deserializeEnchantments((ListTag)this.enchantmentTag).forEach((enchantment, integer) -> {
                if (enchantment != null) {
                    this.enchantments.put(enchantment, integer);
                }
            });
            this.hideGlint = this.hasEnchantment((Enchantment)ModEnchantments.GLINTLESS.get());
        }
    }

    @Override
    public boolean hideGlint() {
        return this.hideGlint;
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        if (tag.contains("Enchantments")) {
            this.enchantmentTag = tag.getList("Enchantments", 10);
            this.updateEnchantmentMap();
        }
    }

    protected void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        if (this.enchantmentTag != null) {
            tag.put("Enchantments", (Tag)this.enchantmentTag);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        CompoundTag tag = packet.getTag();
        if (tag != null) {
            this.handleUpdateTag(tag);
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    public CompoundTag getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.load(tag);
    }

    public CompoundTag getPersistentData() {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag);
        return tag;
    }
}

