/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.client.CustomRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.CampfireRenderer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.neoforged.neoforge.client.model.data.ModelData;

public class EnchantedCampfireRenderer
extends CampfireRenderer {
    private static final RandomSource RANDOM = RandomSource.create();
    private final BlockRenderDispatcher blockRenderDispatcher;
    private boolean renderEnchantment = true;

    public EnchantedCampfireRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        this.blockRenderDispatcher = context.getBlockRenderDispatcher();
    }

    public void render(CampfireBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        super.render(blockEntity, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
        if (blockEntity.getLevel() == null) {
            return;
        }
        if (blockEntity instanceof IEnchantable) {
            IEnchantable enchantable = (IEnchantable)blockEntity;
            boolean bl = this.renderEnchantment = !enchantable.hideGlint();
        }
        if (this.renderEnchantment) {
            poseStack.pushPose();
            PoseStack.Pose pose = poseStack.last();
            SheetedDecalTextureGenerator consumer = new SheetedDecalTextureGenerator(bufferSource.getBuffer(CustomRenderType.GLINT), pose.pose(), pose.normal(), 0.0078125f);
            this.blockRenderDispatcher.renderBatched(blockEntity.getBlockState(), blockEntity.getBlockPos(), (BlockAndTintGetter)blockEntity.getLevel(), poseStack, (VertexConsumer)consumer, true, RANDOM, ModelData.EMPTY, null);
            poseStack.popPose();
        }
    }
}

