/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.client.CustomRenderType;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.ConduitRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.ConduitBlockEntity;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class EnchantedConduitRenderer
extends ConduitRenderer {
    private boolean renderEnchantment = true;

    public EnchantedConduitRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(ConduitBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (blockEntity.getLevel() == null) {
            return;
        }
        if (blockEntity instanceof IEnchantable) {
            IEnchantable enchantable = (IEnchantable)blockEntity;
            this.renderEnchantment = !enchantable.hideGlint();
        }
        float f = (float)blockEntity.tickCount + partialTick;
        if (!blockEntity.isActive()) {
            VertexConsumer shellConsumer;
            float rotation = blockEntity.getActiveRotation(0.0f);
            if (this.renderEnchantment) {
                PoseStack.Pose pose = poseStack.last();
                shellConsumer = VertexMultiConsumer.create((VertexConsumer)new SheetedDecalTextureGenerator(bufferSource.getBuffer(CustomRenderType.GLINT), pose.pose(), pose.normal(), 0.0078125f), (VertexConsumer)SHELL_TEXTURE.buffer(bufferSource, RenderType::entitySolid));
            } else {
                shellConsumer = SHELL_TEXTURE.buffer(bufferSource, RenderType::entitySolid);
            }
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.5f, 0.5f);
            poseStack.mulPose(new Quaternionf().rotationY(rotation * ((float)Math.PI / 180)));
            this.shell.render(poseStack, shellConsumer, packedLight, packedOverlay);
            poseStack.popPose();
        } else {
            VertexConsumer windConsumer;
            float rotation = blockEntity.getActiveRotation(partialTick) * 57.295776f;
            float f2 = Mth.sin((float)(f * 0.1f)) / 2.0f + 0.5f;
            f2 = f2 * f2 + f2;
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.3f + f2 * 0.2f, 0.5f);
            Vector3f vector3f = new Vector3f(0.5f, 1.0f, 0.5f).normalize();
            poseStack.mulPose(new Quaternionf().rotationAxis(rotation * ((float)Math.PI / 180), (Vector3fc)vector3f));
            this.cage.render(poseStack, ACTIVE_SHELL_TEXTURE.buffer(bufferSource, RenderType::entityCutoutNoCull), packedLight, packedOverlay);
            poseStack.popPose();
            int i = blockEntity.tickCount / 66 % 3;
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.5f, 0.5f);
            if (i == 1) {
                poseStack.mulPose(new Quaternionf().rotationX(1.5707964f));
            } else if (i == 2) {
                poseStack.mulPose(new Quaternionf().rotationZ(1.5707964f));
            }
            if (this.renderEnchantment) {
                PoseStack.Pose pose = poseStack.last();
                windConsumer = VertexMultiConsumer.create((VertexConsumer)new SheetedDecalTextureGenerator(bufferSource.getBuffer(CustomRenderType.GLINT), pose.pose(), pose.normal(), 0.0078125f), (VertexConsumer)(i == 1 ? VERTICAL_WIND_TEXTURE : WIND_TEXTURE).buffer(bufferSource, RenderType::entityCutoutNoCull));
            } else {
                windConsumer = (i == 1 ? VERTICAL_WIND_TEXTURE : WIND_TEXTURE).buffer(bufferSource, RenderType::entityCutoutNoCull);
            }
            this.wind.render(poseStack, windConsumer, packedLight, packedOverlay);
            poseStack.popPose();
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.5f, 0.5f);
            poseStack.scale(0.875f, 0.875f, 0.875f);
            poseStack.mulPose(new Quaternionf().rotationXYZ((float)Math.PI, 0.0f, (float)Math.PI));
            this.wind.render(poseStack, windConsumer, packedLight, packedOverlay);
            poseStack.popPose();
            Camera camera = this.renderer.camera;
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.3f + f2 * 0.2f, 0.5f);
            poseStack.scale(0.5f, 0.5f, 0.5f);
            float negYRot = -camera.getYRot();
            poseStack.mulPose(new Quaternionf().rotationYXZ(negYRot * ((float)Math.PI / 180), camera.getXRot() * ((float)Math.PI / 180), (float)Math.PI));
            poseStack.scale(1.3333334f, 1.3333334f, 1.3333334f);
            this.eye.render(poseStack, (blockEntity.isHunting() ? OPEN_EYE_TEXTURE : CLOSED_EYE_TEXTURE).buffer(bufferSource, RenderType::entityCutoutNoCull), packedLight, packedOverlay);
            poseStack.popPose();
        }
    }
}

