/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.compat.jade;

import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.registry.ModRegistry;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.registries.DeferredHolder;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
public class JadeCompat
implements IWailaPlugin {
    public void register(IWailaCommonRegistration registration) {
    }

    public void registerClient(IWailaClientRegistration registration) {
        ArrayList blockClasses = new ArrayList();
        for (DeferredHolder registryObject : ModRegistry.BLOCKS.getEntries()) {
            Block block = (Block)registryObject.get();
            Class<?> blockClass2 = block.getClass();
            if (blockClasses.contains(blockClass2)) continue;
            blockClasses.add(blockClass2);
        }
        blockClasses.forEach(blockClass -> registration.registerBlockComponent((IBlockComponentProvider)EnchantedBlockHandler.INSTANCE, blockClass));
    }

    public static class EnchantedBlockHandler
    implements IBlockComponentProvider {
        private static final ResourceLocation ENCHANTMENTS = new ResourceLocation("enchantableblocks", "enchantments");
        public static final EnchantedBlockHandler INSTANCE = new EnchantedBlockHandler();

        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            BlockEntity blockEntity = blockAccessor.getBlockEntity();
            if (blockEntity instanceof IEnchantable) {
                IEnchantable enchantable = (IEnchantable)blockEntity;
                enchantable.getEnchantments().forEach((enchantment, integer) -> iTooltip.add(enchantment.getFullname(integer.intValue())));
            }
        }

        public ResourceLocation getUid() {
            return ENCHANTMENTS;
        }
    }
}

