/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.datagen.assets;

import com.mrbysco.enchantableblocks.registry.ModRegistry;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;

public class EnchantableBlockstateProvider
extends BlockStateProvider {
    public EnchantableBlockstateProvider(PackOutput packOutput, ExistingFileHelper helper) {
        super(packOutput, "enchantableblocks", helper);
    }

    protected void registerStatesAndModels() {
        this.abstractFurnace(ModRegistry.ENCHANTED_FURNACE, "furnace");
        this.abstractFurnace(ModRegistry.ENCHANTED_BLAST_FURNACE, "blast_furnace");
        this.abstractFurnace(ModRegistry.ENCHANTED_SMOKER, "smoker");
        this.campfire(ModRegistry.ENCHANTED_CAMPFIRE, "campfire");
        this.campfire(ModRegistry.ENCHANTED_SOUL_CAMPFIRE, "soul_campfire");
        this.simpleBlock((Block)ModRegistry.ENCHANTED_MAGMA_BLOCK.get(), (ModelFile)this.models().getExistingFile(this.mcLoc("magma_block")));
        this.dispenser(ModRegistry.ENCHANTED_DISPENSER);
        this.respawnAnchor(ModRegistry.ENCHANTED_RESPAWN_ANCHOR);
        this.hopper(ModRegistry.ENCHANTED_HOPPER);
        this.simpleBlock((Block)ModRegistry.ENCHANTED_CONDUIT.get(), (ModelFile)this.models().getExistingFile(this.mcLoc("conduit")));
        this.simpleBlock((Block)ModRegistry.ENCHANTED_CRAFTING_TABLE.get(), (ModelFile)this.models().getExistingFile(this.mcLoc("crafting_table")));
        this.simpleBlock((Block)ModRegistry.ENCHANTED_CHEST.get(), (ModelFile)this.models().getExistingFile(this.mcLoc("chest")));
        this.simpleBlock((Block)ModRegistry.ENCHANTED_TRAPPED_CHEST.get(), (ModelFile)this.models().getExistingFile(this.mcLoc("chest")));
        this.beehive(ModRegistry.ENCHANTED_BEEHIVE);
        this.simpleCutoutEnchantedBlock(ModRegistry.ENCHANTED_BEACON, "beacon");
        this.simpleCutoutEnchantedBlock(ModRegistry.ENCHANTED_WHITE_BED, "bed");
        this.simpleCutoutEnchantedBlock(ModRegistry.ENCHANTED_ORANGE_BED, "bed");
        this.simpleCutoutEnchantedBlock(ModRegistry.ENCHANTED_MAGENTA_BED, "bed");
        this.simpleCutoutEnchantedBlock(ModRegistry.ENCHANTED_LIGHT_BLUE_BED, "bed");
        this.simpleCutoutEnchantedBlock(ModRegistry.ENCHANTED_YELLOW_BED, "bed");
        this.simpleCutoutEnchantedBlock(ModRegistry.ENCHANTED_LIME_BED, "bed");
        this.simpleCutoutEnchantedBlock(ModRegistry.ENCHANTED_PINK_BED, "bed");
        this.simpleCutoutEnchantedBlock(ModRegistry.ENCHANTED_GRAY_BED, "bed");
        this.simpleCutoutEnchantedBlock(ModRegistry.ENCHANTED_LIGHT_GRAY_BED, "bed");
        this.simpleCutoutEnchantedBlock(ModRegistry.ENCHANTED_CYAN_BED, "bed");
        this.simpleCutoutEnchantedBlock(ModRegistry.ENCHANTED_PURPLE_BED, "bed");
        this.simpleCutoutEnchantedBlock(ModRegistry.ENCHANTED_BLUE_BED, "bed");
        this.simpleCutoutEnchantedBlock(ModRegistry.ENCHANTED_BROWN_BED, "bed");
        this.simpleCutoutEnchantedBlock(ModRegistry.ENCHANTED_GREEN_BED, "bed");
        this.simpleCutoutEnchantedBlock(ModRegistry.ENCHANTED_RED_BED, "bed");
        this.simpleCutoutEnchantedBlock(ModRegistry.ENCHANTED_BLACK_BED, "bed");
    }

    private void simpleCutoutEnchantedBlock(DeferredBlock<? extends Block> enchantedBlock, String originalBlock) {
        this.simpleBlock((Block)enchantedBlock.get(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent("enchantableblocks:block/" + enchantedBlock.getId().getPath(), "minecraft:block/" + originalBlock)).renderType(new ResourceLocation("cutout")));
    }

    private void beehive(DeferredBlock<? extends Block> registryObject) {
        ModelFile.ExistingModelFile beehive = this.models().getExistingFile(this.mcLoc("beehive"));
        ModelFile.ExistingModelFile beehiveHoney = this.models().getExistingFile(this.mcLoc("beehive_honey"));
        this.horizontalBlock((Block)registryObject.get(), arg_0 -> EnchantableBlockstateProvider.lambda$beehive$0((ModelFile)beehiveHoney, (ModelFile)beehive, arg_0));
    }

    private void campfire(DeferredBlock<? extends Block> registryObject, String originalBlock) {
        ModelFile.ExistingModelFile offModel = this.models().getExistingFile(this.mcLoc("campfire_off"));
        ModelFile.ExistingModelFile model = this.models().getExistingFile(this.mcLoc(originalBlock));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)registryObject.get()).partialState().with((Property)CampfireBlock.FACING, (Comparable)Direction.EAST).with((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)offModel).rotationY(270).addModel()).partialState().with((Property)CampfireBlock.FACING, (Comparable)Direction.EAST).with((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)model).rotationY(270).addModel()).partialState().with((Property)CampfireBlock.FACING, (Comparable)Direction.NORTH).with((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)offModel).rotationY(180).addModel()).partialState().with((Property)CampfireBlock.FACING, (Comparable)Direction.NORTH).with((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)model).rotationY(180).addModel()).partialState().with((Property)CampfireBlock.FACING, (Comparable)Direction.SOUTH).with((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)offModel).addModel()).partialState().with((Property)CampfireBlock.FACING, (Comparable)Direction.SOUTH).with((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)CampfireBlock.FACING, (Comparable)Direction.WEST).with((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)offModel).rotationY(90).addModel()).partialState().with((Property)CampfireBlock.FACING, (Comparable)Direction.WEST).with((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)model).rotationY(90).addModel();
    }

    private void abstractFurnace(DeferredBlock<? extends Block> block, String originalBlock) {
        ModelFile.ExistingModelFile normal = this.models().getExistingFile(this.mcLoc(originalBlock));
        ModelFile.ExistingModelFile lit = this.models().getExistingFile(this.mcLoc(originalBlock + "_on"));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block.get()).partialState().with((Property)AbstractFurnaceBlock.FACING, (Comparable)Direction.NORTH).with((Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)normal).addModel()).partialState().with((Property)AbstractFurnaceBlock.FACING, (Comparable)Direction.EAST).with((Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)normal).rotationY(90).addModel()).partialState().with((Property)AbstractFurnaceBlock.FACING, (Comparable)Direction.SOUTH).with((Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)normal).rotationY(180).addModel()).partialState().with((Property)AbstractFurnaceBlock.FACING, (Comparable)Direction.WEST).with((Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)normal).rotationY(270).addModel()).partialState().with((Property)AbstractFurnaceBlock.FACING, (Comparable)Direction.NORTH).with((Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)lit).addModel()).partialState().with((Property)AbstractFurnaceBlock.FACING, (Comparable)Direction.EAST).with((Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)lit).rotationY(90).addModel()).partialState().with((Property)AbstractFurnaceBlock.FACING, (Comparable)Direction.SOUTH).with((Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)lit).rotationY(180).addModel()).partialState().with((Property)AbstractFurnaceBlock.FACING, (Comparable)Direction.WEST).with((Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)lit).rotationY(270).addModel();
    }

    private void dispenser(DeferredBlock<? extends Block> block) {
        ModelFile.ExistingModelFile model = this.models().getExistingFile(this.mcLoc("dispenser"));
        ModelFile.ExistingModelFile vertical = this.models().getExistingFile(this.mcLoc("dispenser_vertical"));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block.get()).partialState().with((Property)DispenserBlock.FACING, (Comparable)Direction.DOWN).modelForState().modelFile((ModelFile)vertical).rotationX(180).addModel()).partialState().with((Property)DispenserBlock.FACING, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)model).rotationY(90).addModel()).partialState().with((Property)DispenserBlock.FACING, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)DispenserBlock.FACING, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)model).rotationY(180).addModel()).partialState().with((Property)DispenserBlock.FACING, (Comparable)Direction.UP).modelForState().modelFile((ModelFile)vertical).addModel()).partialState().with((Property)DispenserBlock.FACING, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)model).rotationY(270).addModel();
    }

    private void hopper(DeferredBlock<? extends Block> block) {
        ModelFile.ExistingModelFile model = this.models().getExistingFile(this.mcLoc("hopper"));
        ModelFile.ExistingModelFile side = this.models().getExistingFile(this.mcLoc("hopper_side"));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block.get()).partialState().with((Property)HopperBlock.FACING, (Comparable)Direction.DOWN).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)HopperBlock.FACING, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)side).rotationY(90).addModel()).partialState().with((Property)HopperBlock.FACING, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)side).addModel()).partialState().with((Property)HopperBlock.FACING, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)side).rotationY(180).addModel()).partialState().with((Property)HopperBlock.FACING, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)side).rotationY(270).addModel();
    }

    private void respawnAnchor(DeferredBlock<? extends Block> block) {
        ModelFile.ExistingModelFile charge0 = this.models().getExistingFile(this.mcLoc("respawn_anchor_0"));
        ModelFile.ExistingModelFile charge1 = this.models().getExistingFile(this.mcLoc("respawn_anchor_1"));
        ModelFile.ExistingModelFile charge2 = this.models().getExistingFile(this.mcLoc("respawn_anchor_2"));
        ModelFile.ExistingModelFile charge3 = this.models().getExistingFile(this.mcLoc("respawn_anchor_3"));
        ModelFile.ExistingModelFile charge4 = this.models().getExistingFile(this.mcLoc("respawn_anchor_4"));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block.get()).partialState().with((Property)RespawnAnchorBlock.CHARGE, (Comparable)Integer.valueOf(0)).modelForState().modelFile((ModelFile)charge0).addModel()).partialState().with((Property)RespawnAnchorBlock.CHARGE, (Comparable)Integer.valueOf(1)).modelForState().modelFile((ModelFile)charge1).addModel()).partialState().with((Property)RespawnAnchorBlock.CHARGE, (Comparable)Integer.valueOf(2)).modelForState().modelFile((ModelFile)charge2).addModel()).partialState().with((Property)RespawnAnchorBlock.CHARGE, (Comparable)Integer.valueOf(3)).modelForState().modelFile((ModelFile)charge3).addModel()).partialState().with((Property)RespawnAnchorBlock.CHARGE, (Comparable)Integer.valueOf(4)).modelForState().modelFile((ModelFile)charge4).addModel();
    }

    private ResourceLocation suffix(ResourceLocation location, String suffix) {
        return new ResourceLocation(location.getNamespace(), location.getPath() + suffix);
    }

    private static /* synthetic */ ModelFile lambda$beehive$0(ModelFile beehiveHoney, ModelFile beehive, BlockState state) {
        return (Integer)state.getValue((Property)BlockStateProperties.LEVEL_HONEY) == 5 ? beehiveHoney : beehive;
    }
}

