/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.datagen.data;

import com.mrbysco.enchantableblocks.registry.ModRegistry;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.CopyBlockState;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;

public class EnchantableLootProvider
extends LootTableProvider {
    public EnchantableLootProvider(PackOutput packOutput) {
        super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(EnchantableBlockLootSubProvider::new, LootContextParamSets.BLOCK)));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, @NotNull ValidationContext validationContext) {
        map.forEach((location, lootTable) -> lootTable.validate(validationContext));
    }

    private static class EnchantableBlockLootSubProvider
    extends BlockLootSubProvider {
        protected EnchantableBlockLootSubProvider() {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags());
        }

        protected void generate() {
            this.add((Block)ModRegistry.ENCHANTED_FURNACE.get(), block -> this.createEnchantableBlockEntityTable((Block)block, Blocks.FURNACE));
            this.add((Block)ModRegistry.ENCHANTED_BLAST_FURNACE.get(), block -> this.createEnchantableBlockEntityTable((Block)block, Blocks.BLAST_FURNACE));
            this.add((Block)ModRegistry.ENCHANTED_SMOKER.get(), block -> this.createEnchantableBlockEntityTable((Block)block, Blocks.SMOKER));
            this.add((Block)ModRegistry.ENCHANTED_BEACON.get(), block -> this.createEnchantableBlockEntityTable((Block)block, Blocks.BEACON));
            this.add((Block)ModRegistry.ENCHANTED_CAMPFIRE.get(), block -> this.createEnchantableBlockEntityTable((Block)block, Blocks.CAMPFIRE));
            this.add((Block)ModRegistry.ENCHANTED_SOUL_CAMPFIRE.get(), block -> this.createEnchantableBlockEntityTable((Block)block, Blocks.SOUL_CAMPFIRE));
            this.add((Block)ModRegistry.ENCHANTED_MAGMA_BLOCK.get(), block -> this.createEnchantableBlockEntityTable((Block)block, Blocks.MAGMA_BLOCK));
            this.add((Block)ModRegistry.ENCHANTED_DISPENSER.get(), block -> this.createEnchantableBlockEntityTable((Block)block, Blocks.DISPENSER));
            this.add((Block)ModRegistry.ENCHANTED_RESPAWN_ANCHOR.get(), block -> this.createEnchantableBlockEntityTable((Block)block, Blocks.RESPAWN_ANCHOR));
            this.add((Block)ModRegistry.ENCHANTED_HOPPER.get(), block -> this.createEnchantableBlockEntityTable((Block)block, Blocks.HOPPER));
            this.add((Block)ModRegistry.ENCHANTED_ENCHANTING_TABLE.get(), block -> this.createEnchantableBlockEntityTable((Block)block, Blocks.ENCHANTING_TABLE));
            this.add((Block)ModRegistry.ENCHANTED_CONDUIT.get(), block -> this.createEnchantableBlockEntityTable((Block)block, Blocks.CONDUIT));
            this.add((Block)ModRegistry.ENCHANTED_CRAFTING_TABLE.get(), block -> this.createEnchantableBlockEntityTable((Block)block, Blocks.CRAFTING_TABLE));
            this.add((Block)ModRegistry.ENCHANTED_BEEHIVE.get(), block -> EnchantableBlockLootSubProvider.createEnchantedBeeHiveDrop(block, Blocks.BEEHIVE));
            this.add((Block)ModRegistry.ENCHANTED_CHEST.get(), block -> this.createEnchantableBlockEntityTable((Block)block, Blocks.CHEST));
            this.add((Block)ModRegistry.ENCHANTED_TRAPPED_CHEST.get(), block -> this.createEnchantableBlockEntityTable((Block)block, Blocks.TRAPPED_CHEST));
            this.add((Block)ModRegistry.ENCHANTED_WHITE_BED.get(), block -> this.createEnchantableBedBlockTable((Block)block, Blocks.WHITE_BED));
            this.add((Block)ModRegistry.ENCHANTED_ORANGE_BED.get(), block -> this.createEnchantableBedBlockTable((Block)block, Blocks.ORANGE_BED));
            this.add((Block)ModRegistry.ENCHANTED_MAGENTA_BED.get(), block -> this.createEnchantableBedBlockTable((Block)block, Blocks.MAGENTA_BED));
            this.add((Block)ModRegistry.ENCHANTED_LIGHT_BLUE_BED.get(), block -> this.createEnchantableBedBlockTable((Block)block, Blocks.LIGHT_BLUE_BED));
            this.add((Block)ModRegistry.ENCHANTED_YELLOW_BED.get(), block -> this.createEnchantableBedBlockTable((Block)block, Blocks.YELLOW_BED));
            this.add((Block)ModRegistry.ENCHANTED_LIME_BED.get(), block -> this.createEnchantableBedBlockTable((Block)block, Blocks.LIME_BED));
            this.add((Block)ModRegistry.ENCHANTED_PINK_BED.get(), block -> this.createEnchantableBedBlockTable((Block)block, Blocks.PINK_BED));
            this.add((Block)ModRegistry.ENCHANTED_GRAY_BED.get(), block -> this.createEnchantableBedBlockTable((Block)block, Blocks.GRAY_BED));
            this.add((Block)ModRegistry.ENCHANTED_LIGHT_GRAY_BED.get(), block -> this.createEnchantableBedBlockTable((Block)block, Blocks.LIGHT_GRAY_BED));
            this.add((Block)ModRegistry.ENCHANTED_CYAN_BED.get(), block -> this.createEnchantableBedBlockTable((Block)block, Blocks.CYAN_BED));
            this.add((Block)ModRegistry.ENCHANTED_PURPLE_BED.get(), block -> this.createEnchantableBedBlockTable((Block)block, Blocks.PURPLE_BED));
            this.add((Block)ModRegistry.ENCHANTED_BLUE_BED.get(), block -> this.createEnchantableBedBlockTable((Block)block, Blocks.BLUE_BED));
            this.add((Block)ModRegistry.ENCHANTED_BROWN_BED.get(), block -> this.createEnchantableBedBlockTable((Block)block, Blocks.BROWN_BED));
            this.add((Block)ModRegistry.ENCHANTED_GREEN_BED.get(), block -> this.createEnchantableBedBlockTable((Block)block, Blocks.GREEN_BED));
            this.add((Block)ModRegistry.ENCHANTED_RED_BED.get(), block -> this.createEnchantableBedBlockTable((Block)block, Blocks.RED_BED));
            this.add((Block)ModRegistry.ENCHANTED_BLACK_BED.get(), block -> this.createEnchantableBedBlockTable((Block)block, Blocks.BLACK_BED));
        }

        protected static LootTable.Builder createEnchantedBeeHiveDrop(Block block, Block originalBlock) {
            return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)originalBlock).when(HAS_SILK_TOUCH)).apply((LootItemFunction.Builder)CopyNbtFunction.copyData((NbtProvider)ContextNbtProvider.BLOCK_ENTITY).copy("Bees", "BlockEntityTag.Bees")).apply((LootItemFunction.Builder)CopyBlockState.copyState((Block)block).copy((Property)BeehiveBlock.HONEY_LEVEL)).apply((LootItemFunction.Builder)CopyNameFunction.copyName((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).apply((LootItemFunction.Builder)CopyNbtFunction.copyData((NbtProvider)ContextNbtProvider.BLOCK_ENTITY).copy("Enchantments", "Enchantments")).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)originalBlock))));
        }

        protected LootTable.Builder createEnchantableBedBlockTable(Block block, Block originalBlock) {
            return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)originalBlock).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BedBlock.PART, (Comparable)BedPart.HEAD)))).apply((LootItemFunction.Builder)CopyNameFunction.copyName((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).apply((LootItemFunction.Builder)CopyNbtFunction.copyData((NbtProvider)ContextNbtProvider.BLOCK_ENTITY).copy("Enchantments", "Enchantments")))));
        }

        protected LootTable.Builder createEnchantableBlockEntityTable(Block block, Block originalBlock) {
            return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)originalBlock).apply((LootItemFunction.Builder)CopyNameFunction.copyName((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).apply((LootItemFunction.Builder)CopyNbtFunction.copyData((NbtProvider)ContextNbtProvider.BLOCK_ENTITY).copy("Enchantments", "Enchantments")))));
        }

        protected Iterable<Block> getKnownBlocks() {
            return ModRegistry.BLOCKS.getEntries().stream().map(holder -> (Block)holder.value())::iterator;
        }
    }
}

