/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.healthindicator.util;

import com.jahirtrap.healthindicator.init.ModConfig;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.neoforged.fml.ModList;

public class CommonUtils {
    public static EntityType getEntityType(Entity entity) {
        if (entity instanceof NeutralMob || entity instanceof Llama) {
            return EntityType.NEUTRAL;
        }
        if (entity instanceof Monster || entity instanceof Slime || entity instanceof Ghast || entity instanceof Hoglin || entity instanceof Phantom || entity instanceof Shulker) {
            return EntityType.HOSTILE;
        }
        return EntityType.PASSIVE;
    }

    public static String getModName(LivingEntity entity) {
        String modId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).getNamespace();
        return ModList.get().getModContainerById(modId).map(container -> container.getModInfo().getDisplayName()).orElse(modId);
    }

    public static String getEntityId(LivingEntity entity) {
        return BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).toString();
    }

    public static boolean checkBlacklist(List<String> blacklist, LivingEntity livingEntity) {
        if (!blacklist.isEmpty()) {
            for (String entityId : blacklist) {
                if (!CommonUtils.getEntityId(livingEntity).equals(entityId)) continue;
                return true;
            }
        }
        return false;
    }

    public static Integer getColor(int defaultValue, String hexColor) {
        int color = defaultValue;
        try {
            if (hexColor.startsWith("#")) {
                hexColor = hexColor.substring(1);
            }
            color = Integer.parseInt(hexColor, 16);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return color;
    }

    public static String formatText(float amount) {
        amount = (float)((double)Math.round(amount * 10.0f) / 10.0);
        return String.format("%.1f", Float.valueOf(amount));
    }

    public static String formatDamageText(float amount) {
        if ((double)(amount = (float)((double)Math.round(amount * 10.0f) / 10.0)) % 1.0 == 0.0) {
            return String.format("%.0f", Float.valueOf(amount)).replace("-", "+");
        }
        return String.format("%.1f", Float.valueOf(amount)).replace("-", "+");
    }

    public static int getHudWidth() {
        return 128;
    }

    public static int getHudHeight(int infoWidth) {
        int value = 30;
        if (ModConfig.barStyle == ModConfig.BarStyle.VANILLA) {
            --value;
        }
        if (!ModConfig.showBar) {
            value = ModConfig.barStyle == ModConfig.BarStyle.VANILLA ? (value -= 5) : (value -= 6);
            if (ModConfig.showModName) {
                value -= 2;
            }
        }
        if (infoWidth == 0) {
            value -= 12;
        }
        if (!ModConfig.showModName) {
            value -= 12;
        }
        return value;
    }

    public static float getRedFromColor(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    public static float getGreenFromColor(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    public static float getBlueFromColor(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    public static float getAlphaFromColor(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f;
    }

    public static int getColorFromRGBA(float red, float green, float blue, float alpha) {
        return (int)(alpha * 255.0f) << 24 | (int)(red * 255.0f) << 16 | (int)(green * 255.0f) << 8 | (int)(blue * 255.0f);
    }

    public static enum EntityType {
        PASSIVE,
        HOSTILE,
        NEUTRAL;

    }
}

