/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.healthindicator.util;

import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RayTrace
implements BlockGetter {
    private static final Predicate<Entity> isVisible = entity -> !entity.isSpectator() && entity.isPickable();
    private static final Minecraft minecraft = Minecraft.getInstance();

    public BlockEntity getBlockEntity(BlockPos pos) {
        return Objects.requireNonNull(RayTrace.minecraft.level).getBlockEntity(pos);
    }

    public BlockState getBlockState(BlockPos pos) {
        return Objects.requireNonNull(RayTrace.minecraft.level).getBlockState(pos);
    }

    public FluidState getFluidState(BlockPos pos) {
        return Objects.requireNonNull(RayTrace.minecraft.level).getFluidState(pos);
    }

    public LivingEntity getEntityInCrosshair(float partialTicks, double reachDistance) {
        Entity entity;
        AABB searchBox;
        Minecraft client = Minecraft.getInstance();
        Entity viewer = client.getCameraEntity();
        if (viewer == null) {
            return null;
        }
        Vec3 position = viewer.getEyePosition(partialTicks);
        Vec3 look = viewer.getViewVector(1.0f);
        Vec3 max = position.add(look.x * reachDistance, look.y * reachDistance, look.z * reachDistance);
        EntityHitResult result = ProjectileUtil.getEntityHitResult((Entity)viewer, (Vec3)position, (Vec3)max, (AABB)(searchBox = viewer.getBoundingBox().expandTowards(look.scale(reachDistance)).inflate(1.0, 1.0, 1.0)), isVisible, (double)(reachDistance * reachDistance));
        if (result != null && (entity = result.getEntity()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            BlockHitResult blockHit = this.clip(this.setupRayTraceContext((Player)Objects.requireNonNull(client.player), reachDistance));
            if (!blockHit.getType().equals((Object)HitResult.Type.MISS)) {
                double blockDistance = blockHit.getLocation().distanceTo(position);
                if (blockDistance > (double)target.distanceTo((Entity)client.player)) {
                    return target;
                }
            } else {
                return target;
            }
        }
        return null;
    }

    private ClipContext setupRayTraceContext(Player player, double distance) {
        float pitch = player.getXRot();
        float yaw = player.getYRot();
        Vec3 fromPos = player.getEyePosition(1.0f);
        float float_3 = Mth.cos((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float float_4 = Mth.sin((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float float_5 = -Mth.cos((float)(-pitch * ((float)Math.PI / 180)));
        float xComponent = float_4 * float_5;
        float yComponent = Mth.sin((float)(-pitch * ((float)Math.PI / 180)));
        float zComponent = float_3 * float_5;
        Vec3 toPos = fromPos.add((double)xComponent * distance, (double)yComponent * distance, (double)zComponent * distance);
        return new ClipContext(fromPos, toPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player);
    }

    public BlockHitResult clip(ClipContext context) {
        return (BlockHitResult)BlockGetter.traverseBlocks((Vec3)context.getFrom(), (Vec3)context.getTo(), (Object)context, (c, pos) -> {
            BlockState block = this.getBlockState((BlockPos)pos);
            if (!block.canOcclude()) {
                return null;
            }
            VoxelShape voxelshape = c.getBlockShape(block, (BlockGetter)this, pos);
            return this.clipWithInteractionOverride(c.getFrom(), c.getTo(), (BlockPos)pos, voxelshape, block);
        }, c -> {
            Vec3 vec3 = c.getFrom().subtract(c.getTo());
            return BlockHitResult.miss((Vec3)c.getTo(), (Direction)Direction.getNearest((double)vec3.x, (double)vec3.y, (double)vec3.z), (BlockPos)BlockPos.containing((Position)c.getTo()));
        });
    }

    public int getHeight() {
        return 0;
    }

    public int getMinBuildHeight() {
        return 0;
    }
}

