/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.codec;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.yungsapi.YungsApiCommon;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;

public class CodecHelper {
    public static Codec<BlockState> BLOCKSTATE_STRING_CODEC = Codec.STRING.xmap(CodecHelper::blockStateFromString, StateHolder::toString);

    public static BlockState blockStateFromString(String blockStateString) {
        BlockState blockState;
        HashMap<String, String> properties = new HashMap<String, String>();
        String blockString = blockStateString;
        int startIndex = blockStateString.indexOf(91);
        int stopIndex = blockStateString.indexOf(93);
        if (startIndex != -1) {
            blockString = blockStateString.substring(0, startIndex);
            if (stopIndex < startIndex) {
                YungsApiCommon.LOGGER.error("JSON: Malformed property {}. Missing a bracket?", (Object)blockStateString);
                YungsApiCommon.LOGGER.error("Using air instead...");
                return Blocks.AIR.defaultBlockState();
            }
            String currKey = "";
            StringBuilder currString = new StringBuilder();
            for (int index = startIndex + 1; index <= stopIndex; ++index) {
                char currChar = blockStateString.charAt(index);
                if (currChar == '=') {
                    currKey = currString.toString();
                    currString = new StringBuilder();
                    continue;
                }
                if (currChar == ',' || currChar == ']') {
                    properties.put(currKey, currString.toString());
                    currString = new StringBuilder();
                    continue;
                }
                currString.append(blockStateString.charAt(index));
            }
        }
        try {
            blockState = ((Block)BuiltInRegistries.BLOCK.get(new ResourceLocation(blockString))).defaultBlockState();
        }
        catch (Exception e) {
            YungsApiCommon.LOGGER.error("JSON: Unable to read block '{}': {}", (Object)blockString, (Object)e.toString());
            YungsApiCommon.LOGGER.error("Using air instead...");
            return Blocks.AIR.defaultBlockState();
        }
        if (properties.size() > 0) {
            blockState = CodecHelper.getConfiguredBlockState(blockState, properties);
        }
        return blockState;
    }

    private static <T extends Comparable<T>> BlockState getConfiguredBlockState(BlockState blockState, Map<String, String> properties) {
        Block block = blockState.getBlock();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            boolean found = false;
            for (Property p : blockState.getProperties()) {
                Property property = p;
                if (!property.getName().equals(key)) continue;
                Comparable val = property.getValue(value).orElse(null);
                if (val == null) {
                    YungsApiCommon.LOGGER.error("JSON: Found null for property {} for block {}", (Object)property, (Object)BuiltInRegistries.BLOCK.getId((Object)block));
                    continue;
                }
                blockState = (BlockState)blockState.setValue(property, val);
                found = true;
                break;
            }
            if (found) continue;
            YungsApiCommon.LOGGER.error("JSON: Unable to find property {} for block {}", (Object)key, (Object)BuiltInRegistries.BLOCK.getId((Object)block));
        }
        return blockState;
    }
}

