/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.module;

import com.yungnickyoung.minecraft.yungsapi.YungsApiNeoForge;
import com.yungnickyoung.minecraft.yungsapi.api.autoregister.AutoRegisterPotion;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegisterField;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegistrationManager;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.brewing.BrewingRecipeRegistry;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;

public class PotionModuleNeoForge {
    public static final List<IBrewingRecipe> BREWING_RECIPES = new ArrayList<IBrewingRecipe>();

    public static void processEntries() {
        YungsApiNeoForge.loadingContextEventBus.addListener(YungsApiNeoForge.buildAutoRegistrar(Registries.POTION, AutoRegistrationManager.POTIONS, PotionModuleNeoForge::buildPotion));
    }

    private static Potion buildPotion(AutoRegisterField data) {
        AutoRegisterPotion autoRegisterPotion = (AutoRegisterPotion)data.object();
        MobEffectInstance mobEffectInstance = autoRegisterPotion.getMobEffectInstance();
        String name = data.name().getNamespace() + "." + data.name().getPath();
        Potion potion = new Potion(name, new MobEffectInstance[]{mobEffectInstance});
        autoRegisterPotion.setSupplier(() -> potion);
        return potion;
    }

    public static void registerBrewingRecipes() {
        BREWING_RECIPES.forEach(BrewingRecipeRegistry::addRecipe);
    }

    public record BrewingRecipe(Supplier<Potion> input, Supplier<Item> ingredient, Supplier<Potion> output) implements IBrewingRecipe
    {
        public boolean isInput(ItemStack input) {
            return PotionUtils.getPotion((ItemStack)input) == this.input.get();
        }

        public boolean isIngredient(ItemStack ingredient) {
            return ingredient.getItem() == this.ingredient.get();
        }

        public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
            if (!this.isInput(input) || !this.isIngredient(ingredient)) {
                return ItemStack.EMPTY;
            }
            ItemStack itemStack = new ItemStack((ItemLike)input.getItem());
            itemStack.setTag(new CompoundTag());
            PotionUtils.setPotion((ItemStack)itemStack, (Potion)this.output.get());
            return itemStack;
        }
    }
}

