/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.yungsapi.api.YungJigsawManager;
import com.yungnickyoung.minecraft.yungsapi.module.StructureTypeModule;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.EnhancedTerrainAdaptation;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.EnhancedTerrainAdaptationType;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.jetbrains.annotations.NotNull;

public class YungJigsawStructure
extends Structure {
    public static final int MAX_TOTAL_STRUCTURE_RADIUS = 128;
    public static final Codec<YungJigsawStructure> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)YungJigsawStructure.settingsCodec((RecordCodecBuilder.Instance)builder), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.CODEC.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)128).fieldOf("size").forGetter(structure -> structure.maxDepth), (App)HeightProvider.CODEC.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)IntProvider.codec((int)0, (int)15).optionalFieldOf("x_offset_in_chunk", (Object)ConstantInt.of((int)0)).forGetter(structure -> structure.xOffsetInChunk), (App)IntProvider.codec((int)0, (int)15).optionalFieldOf("z_offset_in_chunk", (Object)ConstantInt.of((int)0)).forGetter(structure -> structure.zOffsetInChunk), (App)Codec.BOOL.optionalFieldOf("use_expansion_hack", (Object)false).forGetter(structure -> structure.useExpansionHack), (App)Heightmap.Types.CODEC.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.INT.optionalFieldOf("max_y").forGetter(structure -> structure.maxY), (App)Codec.INT.optionalFieldOf("min_y").forGetter(structure -> structure.minY), (App)EnhancedTerrainAdaptationType.ADAPTATION_CODEC.optionalFieldOf("enhanced_terrain_adaptation", (Object)EnhancedTerrainAdaptation.NONE).forGetter(structure -> structure.enhancedTerrainAdaptation)).apply((Applicative)builder, YungJigsawStructure::new)).flatXmap(YungJigsawStructure.verifyRange(), YungJigsawStructure.verifyRange()).codec();
    public final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    public final int maxDepth;
    public final HeightProvider startHeight;
    public final IntProvider xOffsetInChunk;
    public final IntProvider zOffsetInChunk;
    public final boolean useExpansionHack;
    public final Optional<Heightmap.Types> projectStartToHeightmap;
    public final int maxDistanceFromCenter;
    public final Optional<Integer> maxY;
    public final Optional<Integer> minY;
    public final EnhancedTerrainAdaptation enhancedTerrainAdaptation;

    public YungJigsawStructure(Structure.StructureSettings structureSettings, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int maxDepth, HeightProvider startHeight, IntProvider xOffsetInChunk, IntProvider zOffsetInChunk, boolean useExpansionHack, Optional<Heightmap.Types> projectStartToHeightmap, int maxBlockDistanceFromCenter, Optional<Integer> maxY, Optional<Integer> minY, EnhancedTerrainAdaptation enhancedTerrainAdaptation) {
        super(structureSettings);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.maxDepth = maxDepth;
        this.startHeight = startHeight;
        this.xOffsetInChunk = xOffsetInChunk;
        this.zOffsetInChunk = zOffsetInChunk;
        this.useExpansionHack = useExpansionHack;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxBlockDistanceFromCenter;
        this.maxY = maxY;
        this.minY = minY;
        this.enhancedTerrainAdaptation = enhancedTerrainAdaptation;
    }

    private static Function<YungJigsawStructure, DataResult<YungJigsawStructure>> verifyRange() {
        return structure -> {
            int vanillaEdgeBuffer;
            if (structure.terrainAdaptation() != TerrainAdjustment.NONE && structure.enhancedTerrainAdaptation != EnhancedTerrainAdaptation.NONE) {
                return DataResult.error(() -> "YUNG Structure cannot use both vanilla terrain_adaptation and enhanced_terrain_adaptation");
            }
            switch (structure.terrainAdaptation()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case NONE: {
                    int n = 0;
                    break;
                }
                case BURY: 
                case BEARD_THIN: 
                case BEARD_BOX: {
                    int n = vanillaEdgeBuffer = 12;
                }
            }
            if (structure.maxDistanceFromCenter + vanillaEdgeBuffer > 128) {
                return DataResult.error(() -> "YUNG Structure size including terrain adaptation must not exceed 128");
            }
            int enhancedEdgeBuffer = structure.enhancedTerrainAdaptation.getKernelRadius();
            return structure.maxDistanceFromCenter + enhancedEdgeBuffer > 128 ? DataResult.error(() -> "YUNG Structure size including enhanced terrain adaptation must not exceed 128") : DataResult.success((Object)structure);
        };
    }

    @NotNull
    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.chunkPos();
        WorldgenRandom randomSource = context.random();
        int xOffset = this.xOffsetInChunk.sample((RandomSource)randomSource);
        int zOffset = this.zOffsetInChunk.sample((RandomSource)randomSource);
        int startY = this.startHeight.sample((RandomSource)context.random(), new WorldGenerationContext(context.chunkGenerator(), context.heightAccessor()));
        BlockPos startPos = new BlockPos(chunkPos.getBlockX(xOffset), startY, chunkPos.getBlockZ(zOffset));
        return YungJigsawManager.assembleJigsawStructure(context, this.startPool, this.startJigsawName, this.maxDepth, startPos, this.useExpansionHack, this.projectStartToHeightmap, this.maxDistanceFromCenter, this.maxY, this.minY);
    }

    @NotNull
    public BoundingBox adjustBoundingBox(@NotNull BoundingBox boundingBox) {
        return super.adjustBoundingBox(boundingBox).inflatedBy(this.enhancedTerrainAdaptation.getKernelRadius());
    }

    @NotNull
    public StructureType<?> type() {
        return StructureTypeModule.YUNG_JIGSAW;
    }
}

