/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.structure.action;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.yungnickyoung.minecraft.yungsapi.world.structure.action.DelayGenerationAction;
import com.yungnickyoung.minecraft.yungsapi.world.structure.action.StructureAction;
import com.yungnickyoung.minecraft.yungsapi.world.structure.action.TransformAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public interface StructureActionType<C extends StructureAction> {
    public static final Map<ResourceLocation, StructureActionType<?>> ACTION_TYPES_BY_NAME = new HashMap();
    public static final Map<StructureActionType<?>, ResourceLocation> NAME_BY_ACTION_TYPES = new HashMap();
    public static final Codec<StructureActionType<?>> ACTION_TYPE_CODEC = ResourceLocation.CODEC.flatXmap(resourceLocation -> Optional.ofNullable(ACTION_TYPES_BY_NAME.get(resourceLocation)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown structure action type: " + resourceLocation)), actionType -> Optional.of(NAME_BY_ACTION_TYPES.get(actionType)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "No ID found for structure action type " + actionType + ". Is it registered?")));
    public static final Codec<StructureAction> ACTION_CODEC = ACTION_TYPE_CODEC.dispatch("type", StructureAction::type, StructureActionType::codec);
    public static final StructureActionType<TransformAction> TRANSFORM = StructureActionType.register("transform", TransformAction.CODEC);
    public static final StructureActionType<DelayGenerationAction> DELAY_GENERATION = StructureActionType.register("delay_generation", DelayGenerationAction.CODEC);

    public static <C extends StructureAction> StructureActionType<C> register(ResourceLocation resourceLocation, Codec<C> codec) {
        StructureActionType<C> actionType = () -> codec;
        ACTION_TYPES_BY_NAME.put(resourceLocation, actionType);
        NAME_BY_ACTION_TYPES.put(actionType, resourceLocation);
        return actionType;
    }

    private static <C extends StructureAction> StructureActionType<C> register(String id, Codec<C> codec) {
        return StructureActionType.register(new ResourceLocation("yungsapi", id), codec);
    }

    public Codec<C> codec();
}

