/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.structure.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.yungsapi.YungsApiCommon;
import com.yungnickyoung.minecraft.yungsapi.mixin.accessor.SinglePoolElementAccessor;
import com.yungnickyoung.minecraft.yungsapi.world.structure.condition.StructureCondition;
import com.yungnickyoung.minecraft.yungsapi.world.structure.condition.StructureConditionType;
import com.yungnickyoung.minecraft.yungsapi.world.structure.context.StructureContext;
import com.yungnickyoung.minecraft.yungsapi.world.structure.jigsaw.PieceEntry;
import com.yungnickyoung.minecraft.yungsapi.world.structure.jigsaw.element.YungJigsawSinglePoolElement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class PieceInHorizontalDirectionCondition
extends StructureCondition {
    private static final ResourceLocation ALL = new ResourceLocation("yungsapi", "all");
    public static final Codec<PieceInHorizontalDirectionCondition> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.CODEC.listOf().optionalFieldOf("pieces", new ArrayList()).forGetter(conditon -> conditon.matchPieces), (App)Codec.INT.fieldOf("range").forGetter(conditon -> conditon.range), (App)Rotation.CODEC.fieldOf("rotation").forGetter(conditon -> conditon.rotation)).apply((Applicative)builder, PieceInHorizontalDirectionCondition::new));
    private final List<ResourceLocation> matchPieces;
    private final Integer range;
    private final Rotation rotation;

    public PieceInHorizontalDirectionCondition(List<ResourceLocation> pieces, int range, Rotation rotation) {
        this.matchPieces = pieces;
        this.range = range;
        this.rotation = rotation;
        if (this.matchPieces.isEmpty()) {
            this.matchPieces.add(ALL);
        }
    }

    @Override
    public StructureConditionType<?> type() {
        return StructureConditionType.PIECE_IN_HORIZONTAL_DIRECTION;
    }

    @Override
    public boolean passes(StructureContext ctx) {
        StructureTemplateManager templateManager = ctx.structureTemplateManager();
        List<PieceEntry> pieces = ctx.pieces();
        Rotation pieceRotation = ctx.rotation();
        PieceEntry pieceEntry = ctx.pieceEntry();
        if (templateManager == null) {
            YungsApiCommon.LOGGER.error("Missing required field 'structureTemplateManager' for piece_in_horizontal_direction condition!");
        }
        if (pieces == null) {
            YungsApiCommon.LOGGER.error("Missing required field 'pieces' for piece_in_horizontal_direction condition!");
        }
        if (this.rotation == null) {
            YungsApiCommon.LOGGER.error("Missing required field 'rotation' for piece_in_horizontal_direction condition!");
        }
        if (pieceEntry == null) {
            YungsApiCommon.LOGGER.error("Missing required field 'pieceEntry' for piece_in_horizontal_direction condition!");
        }
        if (templateManager == null || pieces == null || this.rotation == null || pieceEntry == null) {
            return false;
        }
        PoolElementStructurePiece piece = pieceEntry.getPiece();
        Rotation searchRotation = pieceRotation.getRotated(this.rotation);
        int negX = 0;
        int negZ = 0;
        int posX = 0;
        int posZ = 0;
        switch (searchRotation) {
            case NONE: {
                negZ = this.range;
                break;
            }
            case CLOCKWISE_90: {
                posX = this.range;
                break;
            }
            case CLOCKWISE_180: {
                posZ = this.range;
                break;
            }
            case COUNTERCLOCKWISE_90: {
                negX = this.range;
            }
        }
        BoundingBox searchBox = new BoundingBox(piece.getBoundingBox().minX() - negX, piece.getBoundingBox().minY(), piece.getBoundingBox().minZ() - negZ, piece.getBoundingBox().maxX() + posX, piece.getBoundingBox().maxY(), piece.getBoundingBox().maxZ() + posZ);
        for (PieceEntry otherPieceEntry : pieces) {
            PoolElementStructurePiece otherPiece = otherPieceEntry.getPiece();
            if (!(otherPiece.getElement() instanceof SinglePoolElement) && !(otherPiece.getElement() instanceof YungJigsawSinglePoolElement) || otherPiece.getBoundingBox().equals((Object)piece.getBoundingBox())) continue;
            StructureTemplate otherStructureTemplate = otherPiece.getElement() instanceof SinglePoolElement ? ((SinglePoolElementAccessor)otherPiece.getElement()).callGetTemplate(templateManager) : ((YungJigsawSinglePoolElement)otherPiece.getElement()).getTemplate(templateManager);
            for (ResourceLocation matchPieceId : this.matchPieces) {
                StructureTemplate structureTemplate = templateManager.getOrCreate(matchPieceId);
                if (otherStructureTemplate != structureTemplate && !matchPieceId.equals((Object)ALL) || !otherPiece.getBoundingBox().intersects(searchBox) || otherPiece.getBoundingBox().intersects(piece.getBoundingBox())) continue;
                return true;
            }
        }
        return false;
    }
}

