/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.structure.jigsaw;

import com.mojang.datafixers.util.Pair;
import com.yungnickyoung.minecraft.yungsapi.YungsApiCommon;
import com.yungnickyoung.minecraft.yungsapi.mixin.accessor.StructureTemplatePoolAccessor;
import com.yungnickyoung.minecraft.yungsapi.util.BoxOctree;
import com.yungnickyoung.minecraft.yungsapi.world.structure.context.StructureContext;
import com.yungnickyoung.minecraft.yungsapi.world.structure.jigsaw.assembler.JigsawStructureAssembler;
import com.yungnickyoung.minecraft.yungsapi.world.structure.jigsaw.element.YungJigsawPoolElement;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;

public class JigsawManager {
    public static Optional<Structure.GenerationStub> assembleJigsawStructure(Structure.GenerationContext generationContext, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawNameOptional, int maxDepth, BlockPos locatePos, boolean useExpansionHack, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, Optional<Integer> maxY, Optional<Integer> minY) {
        RegistryAccess registryAccess = generationContext.registryAccess();
        ChunkGenerator chunkGenerator = generationContext.chunkGenerator();
        StructureTemplateManager structureManager = generationContext.structureTemplateManager();
        LevelHeightAccessor levelHeightAccessor = generationContext.heightAccessor();
        WorldgenRandom worldgenRandom = generationContext.random();
        Registry registry = registryAccess.registryOrThrow(Registries.TEMPLATE_POOL);
        Optional<PoolElementStructurePiece> startPieceOptional = JigsawManager.getStartPiece(startPool, startJigsawNameOptional, locatePos, structureManager, (RandomSource)worldgenRandom);
        if (startPieceOptional.isEmpty()) {
            return Optional.empty();
        }
        PoolElementStructurePiece startPiece = startPieceOptional.get();
        BlockPos startingPosOffset = locatePos.subtract((Vec3i)startPiece.getPosition());
        BoundingBox pieceBoundingBox = startPiece.getBoundingBox();
        int bbCenterX = (pieceBoundingBox.maxX() + pieceBoundingBox.minX()) / 2;
        int bbCenterZ = (pieceBoundingBox.maxZ() + pieceBoundingBox.minZ()) / 2;
        int bbCenterY = projectStartToHeightmap.map(types -> locatePos.getY() + chunkGenerator.getFirstFreeHeight(bbCenterX, bbCenterZ, types, levelHeightAccessor, generationContext.randomState())).orElseGet(() -> startPiece.getPosition().getY());
        int adjustedPieceCenterY = bbCenterY + startingPosOffset.getY();
        int yAdjustment = pieceBoundingBox.minY() + startPiece.getGroundLevelDelta();
        startPiece.move(0, bbCenterY - yAdjustment, 0);
        AABB aABB = new AABB((double)(bbCenterX - maxDistanceFromCenter), (double)(adjustedPieceCenterY - maxDistanceFromCenter), (double)(bbCenterZ - maxDistanceFromCenter), (double)(bbCenterX + maxDistanceFromCenter + 1), (double)(adjustedPieceCenterY + maxDistanceFromCenter + 1), (double)(bbCenterZ + maxDistanceFromCenter + 1));
        BoxOctree maxStructureBounds = new BoxOctree(aABB);
        maxStructureBounds.addBox(AABB.of((BoundingBox)pieceBoundingBox));
        return Optional.of(new Structure.GenerationStub(new BlockPos(bbCenterX, adjustedPieceCenterY, bbCenterZ), structurePiecesBuilder -> {
            if (maxDepth <= 0) {
                return;
            }
            JigsawStructureAssembler assembler = new JigsawStructureAssembler(new JigsawStructureAssembler.Settings().poolRegistry((Registry<StructureTemplatePool>)registry).maxDepth(maxDepth).chunkGenerator(chunkGenerator).structureTemplateManager(structureManager).randomState(generationContext.randomState()).rand((RandomSource)worldgenRandom).maxY(maxY).minY(minY).useExpansionHack(useExpansionHack).levelHeightAccessor(levelHeightAccessor));
            assembler.assembleStructure(startPiece, maxStructureBounds);
            assembler.addAllPiecesToStructureBuilder((StructurePiecesBuilder)structurePiecesBuilder);
        }));
    }

    private static Optional<PoolElementStructurePiece> getStartPiece(Holder<StructureTemplatePool> startPoolHolder, Optional<ResourceLocation> startJigsawNameOptional, BlockPos locatePos, StructureTemplateManager structureTemplateManager, RandomSource rand) {
        int chosenPieceWeight;
        StructureTemplatePool startPool = (StructureTemplatePool)startPoolHolder.value();
        ObjectArrayList candidatePoolElements = new ObjectArrayList(((StructureTemplatePoolAccessor)startPool).getRawTemplates());
        Util.shuffle((List)candidatePoolElements, (RandomSource)rand);
        Rotation rotation = Rotation.getRandom((RandomSource)rand);
        for (int totalWeightSum = candidatePoolElements.stream().mapToInt(Pair::getSecond).reduce(0, Integer::sum); candidatePoolElements.size() > 0 && totalWeightSum > 0; totalWeightSum -= chosenPieceWeight) {
            StructureContext ctx;
            YungJigsawPoolElement yungElement;
            BlockPos anchorPos;
            Pair chosenPoolElementPair = null;
            for (Pair candidatePiecePair : candidatePoolElements) {
                YungJigsawPoolElement yungElement2;
                StructurePoolElement candidatePiece = (StructurePoolElement)candidatePiecePair.getFirst();
                if (!(candidatePiece instanceof YungJigsawPoolElement) || !(yungElement2 = (YungJigsawPoolElement)candidatePiece).isPriorityPiece()) continue;
                chosenPoolElementPair = candidatePiecePair;
                break;
            }
            if (chosenPoolElementPair == null) {
                Pair candidatePiecePair;
                int chosenWeight = rand.nextInt(totalWeightSum) + 1;
                candidatePiecePair = candidatePoolElements.iterator();
                while (candidatePiecePair.hasNext()) {
                    Pair candidate = (Pair)candidatePiecePair.next();
                    if ((chosenWeight -= ((Integer)candidate.getSecond()).intValue()) > 0) continue;
                    chosenPoolElementPair = candidate;
                    break;
                }
            }
            StructurePoolElement chosenPoolElement = (StructurePoolElement)chosenPoolElementPair.getFirst();
            chosenPieceWeight = (Integer)chosenPoolElementPair.getSecond();
            if (chosenPoolElement == EmptyPoolElement.INSTANCE) {
                return Optional.empty();
            }
            if (startJigsawNameOptional.isPresent()) {
                ResourceLocation name = startJigsawNameOptional.get();
                Optional<BlockPos> optional = JigsawManager.getPosOfJigsawBlockWithName(chosenPoolElement, name, locatePos, rotation, structureTemplateManager, rand);
                if (optional.isEmpty()) {
                    YungsApiCommon.LOGGER.error("No starting jigsaw with Name {} found in start pool {}", (Object)name, (Object)startPoolHolder.unwrapKey().map(pool -> pool.location().toString()).orElse("<unregistered>"));
                    return Optional.empty();
                }
                anchorPos = optional.get();
            } else {
                anchorPos = locatePos;
            }
            BlockPos startingPosOffset = anchorPos.subtract((Vec3i)locatePos);
            BlockPos adjustedStartPos = locatePos.subtract((Vec3i)startingPosOffset);
            if (chosenPoolElement instanceof YungJigsawPoolElement && !(yungElement = (YungJigsawPoolElement)chosenPoolElement).passesConditions(ctx = new StructureContext.Builder().structureTemplateManager(structureTemplateManager).pos(adjustedStartPos).rotation(rotation).depth(0).random(rand).build())) {
                candidatePoolElements.remove((Object)chosenPoolElementPair);
                continue;
            }
            return Optional.of(new PoolElementStructurePiece(structureTemplateManager, chosenPoolElement, adjustedStartPos, chosenPoolElement.getGroundLevelDelta(), rotation, chosenPoolElement.getBoundingBox(structureTemplateManager, adjustedStartPos, rotation)));
        }
        return Optional.empty();
    }

    private static Optional<BlockPos> getPosOfJigsawBlockWithName(StructurePoolElement structurePoolElement, ResourceLocation name, BlockPos startPos, Rotation rotation, StructureTemplateManager structureTemplateManager, RandomSource rand) {
        try {
            List shuffledJigsawBlocks = structurePoolElement.getShuffledJigsawBlocks(structureTemplateManager, startPos, rotation, rand);
            for (StructureTemplate.StructureBlockInfo jigsawBlockInfo : shuffledJigsawBlocks) {
                ResourceLocation jigsawBlockName = ResourceLocation.tryParse((String)jigsawBlockInfo.nbt().getString("name"));
                if (!name.equals((Object)jigsawBlockName)) continue;
                return Optional.of(jigsawBlockInfo.pos());
            }
        }
        catch (ConcurrentModificationException e) {
            YungsApiCommon.LOGGER.error("Encountered unexpected ConcurrentModException while trying to get jigsaw block with name {} from structure pool element {}", (Object)name, (Object)structurePoolElement);
            YungsApiCommon.LOGGER.error("Ignoring - the structure will still generate, but /locate will not point to the structure's anchor block.");
            return Optional.empty();
        }
        return Optional.empty();
    }
}

