/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.beardifier;

import com.yungnickyoung.minecraft.yungsapi.mixin.accessor.BeardifierAccessor;
import com.yungnickyoung.minecraft.yungsapi.world.structure.YungJigsawStructure;
import com.yungnickyoung.minecraft.yungsapi.world.structure.jigsaw.element.YungJigsawPoolElement;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.EnhancedTerrainAdaptation;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.beardifier.EnhancedBeardifierData;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.beardifier.EnhancedBeardifierRigid;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.beardifier.EnhancedJigsawJunction;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.List;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class EnhancedBeardifierHelper {
    public static Beardifier forStructuresInChunk(StructureManager structureManager, ChunkPos chunkPos, Beardifier original) {
        ObjectArrayList enhancedBeardifierRigidList = new ObjectArrayList(10);
        ObjectArrayList enhancedJunctionList = new ObjectArrayList(10);
        int chunkMinBlockX = chunkPos.getMinBlockX();
        int chunkMinBlockZ = chunkPos.getMinBlockZ();
        List structureStarts = structureManager.startsForStructure(chunkPos, structure -> structure instanceof YungJigsawStructure);
        for (StructureStart structureStart : structureStarts) {
            EnhancedTerrainAdaptation structureTerrainAdaptation = ((YungJigsawStructure)structureStart.getStructure()).enhancedTerrainAdaptation;
            int kernelRadius = structureTerrainAdaptation.getKernelRadius();
            for (StructurePiece structurePiece2 : structureStart.getPieces()) {
                YungJigsawPoolElement yungElement;
                PoolElementStructurePiece poolPiece;
                StructurePoolElement structurePoolElement;
                if (!(structurePiece2 instanceof PoolElementStructurePiece) || !((structurePoolElement = (poolPiece = (PoolElementStructurePiece)structurePiece2).getElement()) instanceof YungJigsawPoolElement) || !(yungElement = (YungJigsawPoolElement)structurePoolElement).getEnhancedTerrainAdaptation().isPresent()) continue;
                kernelRadius = Math.max(kernelRadius, yungElement.getEnhancedTerrainAdaptation().get().getKernelRadius());
            }
            int maxKernelRadius = kernelRadius;
            if (maxKernelRadius <= 0) continue;
            List<StructurePiece> nearbyPieces = structureStart.getPieces().stream().filter(structurePiece -> structurePiece.isCloseToChunk(chunkPos, maxKernelRadius)).toList();
            for (StructurePiece nearbyPiece : nearbyPieces) {
                if (nearbyPiece instanceof PoolElementStructurePiece) {
                    YungJigsawPoolElement yungElement;
                    PoolElementStructurePiece poolElementPiece = (PoolElementStructurePiece)nearbyPiece;
                    StructureTemplatePool.Projection projection = poolElementPiece.getElement().getProjection();
                    EnhancedTerrainAdaptation pieceTerrainAdaptation = structureTerrainAdaptation;
                    StructurePoolElement structurePoolElement = poolElementPiece.getElement();
                    if (structurePoolElement instanceof YungJigsawPoolElement && (yungElement = (YungJigsawPoolElement)structurePoolElement).getEnhancedTerrainAdaptation().isPresent()) {
                        pieceTerrainAdaptation = yungElement.getEnhancedTerrainAdaptation().get();
                    }
                    if (pieceTerrainAdaptation == EnhancedTerrainAdaptation.NONE) continue;
                    int pieceKernelRadius = pieceTerrainAdaptation.getKernelRadius();
                    if (projection == StructureTemplatePool.Projection.RIGID) {
                        enhancedBeardifierRigidList.add((Object)new EnhancedBeardifierRigid(poolElementPiece.getBoundingBox(), pieceTerrainAdaptation, poolElementPiece.getGroundLevelDelta()));
                    }
                    for (JigsawJunction jigsawJunction : poolElementPiece.getJunctions()) {
                        int sourceX = jigsawJunction.getSourceX();
                        int sourceZ = jigsawJunction.getSourceZ();
                        if (sourceX <= chunkMinBlockX - pieceKernelRadius || sourceZ <= chunkMinBlockZ - pieceKernelRadius || sourceX >= chunkMinBlockX + 15 + pieceKernelRadius || sourceZ >= chunkMinBlockZ + 15 + pieceKernelRadius) continue;
                        enhancedJunctionList.add((Object)new EnhancedJigsawJunction(jigsawJunction, pieceTerrainAdaptation));
                    }
                    continue;
                }
                if (structureTerrainAdaptation == EnhancedTerrainAdaptation.NONE) continue;
                enhancedBeardifierRigidList.add((Object)new EnhancedBeardifierRigid(nearbyPiece.getBoundingBox(), structureTerrainAdaptation, 0));
            }
        }
        Beardifier newBeardifier = new Beardifier(((BeardifierAccessor)original).getPieceIterator(), ((BeardifierAccessor)original).getJunctionIterator());
        ((EnhancedBeardifierData)newBeardifier).setEnhancedRigidIterator((ObjectListIterator<EnhancedBeardifierRigid>)enhancedBeardifierRigidList.iterator());
        ((EnhancedBeardifierData)newBeardifier).setEnhancedJunctionIterator((ObjectListIterator<EnhancedJigsawJunction>)enhancedJunctionList.iterator());
        return newBeardifier;
    }

    public static double computeDensity(DensityFunction.FunctionContext ctx, double density, EnhancedBeardifierData data) {
        int x = ctx.blockX();
        int y = ctx.blockY();
        int z = ctx.blockZ();
        while (data.getEnhancedRigidIterator() != null && data.getEnhancedRigidIterator().hasNext()) {
            EnhancedBeardifierRigid rigid = (EnhancedBeardifierRigid)data.getEnhancedRigidIterator().next();
            BoundingBox pieceBoundingBox = rigid.pieceBoundingBox();
            int adjustedPieceMinY = pieceBoundingBox.minY();
            EnhancedTerrainAdaptation pieceTerrainAdaptation = rigid.pieceTerrainAdaptation();
            int xDistanceToBoundingBox = Math.max(0, Math.max(pieceBoundingBox.minX() - x, x - pieceBoundingBox.maxX()));
            int yDistanceToBoundingBox = Math.max(0, Math.max(adjustedPieceMinY - y, y - pieceBoundingBox.maxY()));
            int zDistanceToBoundingBox = Math.max(0, Math.max(pieceBoundingBox.minZ() - z, z - pieceBoundingBox.maxZ()));
            int yDistanceToAdjustedPieceBottom = y - adjustedPieceMinY;
            double densityFactor = 0.0;
            if (pieceTerrainAdaptation != EnhancedTerrainAdaptation.NONE) {
                densityFactor = pieceTerrainAdaptation.computeDensityFactor(xDistanceToBoundingBox, yDistanceToBoundingBox, zDistanceToBoundingBox, yDistanceToAdjustedPieceBottom) * 0.8;
            }
            density += densityFactor;
        }
        data.getEnhancedRigidIterator().back(Integer.MAX_VALUE);
        while (data.getEnhancedJunctionIterator() != null && data.getEnhancedJunctionIterator().hasNext()) {
            EnhancedJigsawJunction enhancedJigsawJunction = (EnhancedJigsawJunction)data.getEnhancedJunctionIterator().next();
            JigsawJunction jigsawJunction = enhancedJigsawJunction.jigsawJunction();
            EnhancedTerrainAdaptation pieceTerrainAdaptation = enhancedJigsawJunction.pieceTerrainAdaptation();
            int xDistanceToJunction = x - jigsawJunction.getSourceX();
            int yDistanceToJunction = y - jigsawJunction.getSourceGroundY();
            int zDistanceToJunction = z - jigsawJunction.getSourceZ();
            density += pieceTerrainAdaptation.computeDensityFactor(xDistanceToJunction, yDistanceToJunction, zDistanceToJunction, yDistanceToJunction) * 0.4;
        }
        data.getEnhancedJunctionIterator().back(Integer.MAX_VALUE);
        return density;
    }
}

