/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass;

import com.chaosthedude.naturescompass.config.ConfigHandler;
import com.chaosthedude.naturescompass.items.NaturesCompassItem;
import com.chaosthedude.naturescompass.network.SearchPacket;
import com.chaosthedude.naturescompass.network.SyncPacket;
import com.chaosthedude.naturescompass.network.TeleportPacket;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;
import net.neoforged.neoforge.server.permission.events.PermissionGatherEvent;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContextKey;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;
import net.neoforged.neoforge.server.permission.nodes.PermissionTypes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="naturescompass")
public class NaturesCompass {
    public static final String MODID = "naturescompass";
    public static final PermissionNode<Boolean> TELEPORT_PERMISSION = new PermissionNode("naturescompass", "naturescompass.teleport", PermissionTypes.BOOLEAN, (player, playerUUID, context) -> false, new PermissionDynamicContextKey[0]);
    public static final Logger LOGGER = LogManager.getLogger((String)"naturescompass");
    public static NaturesCompassItem naturesCompass;
    public static boolean canTeleport;
    public static List<ResourceLocation> allowedBiomes;
    public static ListMultimap<ResourceLocation, ResourceLocation> dimensionKeysForAllowedBiomeKeys;
    public static NaturesCompass instance;

    public NaturesCompass(IEventBus bus, Dist dist) {
        instance = this;
        bus.addListener(this::preInit);
        bus.addListener(this::buildCreativeTabContents);
        bus.addListener(this::registerPayloads);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigHandler.GENERAL_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigHandler.CLIENT_SPEC);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    private void preInit(FMLCommonSetupEvent event) {
        allowedBiomes = new ArrayList<ResourceLocation>();
        dimensionKeysForAllowedBiomeKeys = ArrayListMultimap.create();
    }

    private void buildCreativeTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept(new ItemStack((ItemLike)naturesCompass));
        }
    }

    private void registerPayloads(RegisterPayloadHandlerEvent event) {
        IPayloadRegistrar registrar = event.registrar(MODID);
        registrar.play(SearchPacket.ID, SearchPacket::read, handler -> handler.server(SearchPacket::handle));
        registrar.play(TeleportPacket.ID, TeleportPacket::read, handler -> handler.server(TeleportPacket::handle));
        registrar.play(SyncPacket.ID, SyncPacket::read, handler -> handler.client(SyncPacket::handle));
    }

    @SubscribeEvent
    public void registerNodes(PermissionGatherEvent.Nodes event) {
        event.addNodes(new PermissionNode[]{TELEPORT_PERMISSION});
    }
}

