/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.network;

import com.chaosthedude.naturescompass.items.NaturesCompassItem;
import com.chaosthedude.naturescompass.util.ItemUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record SearchPacket(ResourceLocation biomeKey, BlockPos pos) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("naturescompass", "search");

    public static SearchPacket read(FriendlyByteBuf buf) {
        return new SearchPacket(buf.readResourceLocation(), buf.readBlockPos());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeResourceLocation(this.biomeKey);
        buf.writeBlockPos(this.pos);
    }

    public static void handle(SearchPacket packet, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            ItemStack stack;
            if (context.player().isPresent() && context.level().isPresent() && !(stack = ItemUtils.getHeldNatureCompass((Player)context.player().get())).isEmpty()) {
                NaturesCompassItem natureCompass = (NaturesCompassItem)stack.getItem();
                natureCompass.searchForBiome((ServerLevel)context.level().get(), (Player)context.player().get(), packet.biomeKey, packet.pos, stack);
            }
        });
    }

    public ResourceLocation id() {
        return ID;
    }
}

