/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.network;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record SyncPacket(boolean canTeleport, List<ResourceLocation> allowedBiomes, ListMultimap<ResourceLocation, ResourceLocation> dimensionKeysForAllowedBiomeKeys) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("naturescompass", "sync");

    public static SyncPacket read(FriendlyByteBuf buf) {
        boolean canTeleport = buf.readBoolean();
        ArrayList<ResourceLocation> allowedBiomes = new ArrayList<ResourceLocation>();
        ArrayListMultimap dimensionKeysForAllowedBiomeKeys = ArrayListMultimap.create();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            ResourceLocation biomeKey = buf.readResourceLocation();
            int numDimensions = buf.readInt();
            ArrayList<ResourceLocation> dimensionKeys = new ArrayList<ResourceLocation>();
            for (int j = 0; j < numDimensions; ++j) {
                dimensionKeys.add(buf.readResourceLocation());
            }
            if (biomeKey == null) continue;
            allowedBiomes.add(biomeKey);
            dimensionKeysForAllowedBiomeKeys.putAll((Object)biomeKey, dimensionKeys);
        }
        return new SyncPacket(canTeleport, allowedBiomes, (ListMultimap<ResourceLocation, ResourceLocation>)dimensionKeysForAllowedBiomeKeys);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.canTeleport);
        buf.writeInt(this.allowedBiomes.size());
        for (ResourceLocation biomeKey : this.allowedBiomes) {
            buf.writeResourceLocation(biomeKey);
            List dimensionKeys = this.dimensionKeysForAllowedBiomeKeys.get((Object)biomeKey);
            buf.writeInt(dimensionKeys.size());
            for (ResourceLocation dimensionKey : dimensionKeys) {
                buf.writeResourceLocation(dimensionKey);
            }
        }
    }

    public static void handle(SyncPacket packet, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            NaturesCompass.canTeleport = packet.canTeleport;
            NaturesCompass.allowedBiomes = packet.allowedBiomes;
            NaturesCompass.dimensionKeysForAllowedBiomeKeys = packet.dimensionKeysForAllowedBiomeKeys;
        });
    }

    public ResourceLocation id() {
        return ID;
    }
}

