/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes;

import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.entities.PipeFrameEntity;
import de.ellpeck.prettypipes.entities.PipeFrameRenderer;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.items.ModuleItem;
import de.ellpeck.prettypipes.items.ModuleTier;
import de.ellpeck.prettypipes.items.PipeFrameItem;
import de.ellpeck.prettypipes.items.WrenchItem;
import de.ellpeck.prettypipes.misc.ItemEquality;
import de.ellpeck.prettypipes.misc.ModuleClearingRecipe;
import de.ellpeck.prettypipes.packets.PacketButton;
import de.ellpeck.prettypipes.packets.PacketCraftingModuleTransfer;
import de.ellpeck.prettypipes.packets.PacketGhostSlot;
import de.ellpeck.prettypipes.packets.PacketItemEnterPipe;
import de.ellpeck.prettypipes.packets.PacketNetworkItems;
import de.ellpeck.prettypipes.packets.PacketRequest;
import de.ellpeck.prettypipes.pipe.IPipeConnectable;
import de.ellpeck.prettypipes.pipe.PipeBlock;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import de.ellpeck.prettypipes.pipe.PipeRenderer;
import de.ellpeck.prettypipes.pipe.containers.AbstractPipeContainer;
import de.ellpeck.prettypipes.pipe.containers.MainPipeContainer;
import de.ellpeck.prettypipes.pipe.containers.MainPipeGui;
import de.ellpeck.prettypipes.pipe.modules.HighPriorityModuleItem;
import de.ellpeck.prettypipes.pipe.modules.LowPriorityModuleItem;
import de.ellpeck.prettypipes.pipe.modules.RedstoneModuleItem;
import de.ellpeck.prettypipes.pipe.modules.SortingModuleItem;
import de.ellpeck.prettypipes.pipe.modules.SpeedModuleItem;
import de.ellpeck.prettypipes.pipe.modules.craft.CraftingModuleContainer;
import de.ellpeck.prettypipes.pipe.modules.craft.CraftingModuleGui;
import de.ellpeck.prettypipes.pipe.modules.craft.CraftingModuleItem;
import de.ellpeck.prettypipes.pipe.modules.extraction.ExtractionModuleContainer;
import de.ellpeck.prettypipes.pipe.modules.extraction.ExtractionModuleGui;
import de.ellpeck.prettypipes.pipe.modules.extraction.ExtractionModuleItem;
import de.ellpeck.prettypipes.pipe.modules.filter.FilterIncreaseModuleContainer;
import de.ellpeck.prettypipes.pipe.modules.filter.FilterIncreaseModuleGui;
import de.ellpeck.prettypipes.pipe.modules.filter.FilterIncreaseModuleItem;
import de.ellpeck.prettypipes.pipe.modules.insertion.FilterModuleContainer;
import de.ellpeck.prettypipes.pipe.modules.insertion.FilterModuleGui;
import de.ellpeck.prettypipes.pipe.modules.insertion.FilterModuleItem;
import de.ellpeck.prettypipes.pipe.modules.modifier.FilterModifierModuleContainer;
import de.ellpeck.prettypipes.pipe.modules.modifier.FilterModifierModuleGui;
import de.ellpeck.prettypipes.pipe.modules.modifier.FilterModifierModuleItem;
import de.ellpeck.prettypipes.pipe.modules.retrieval.RetrievalModuleContainer;
import de.ellpeck.prettypipes.pipe.modules.retrieval.RetrievalModuleGui;
import de.ellpeck.prettypipes.pipe.modules.retrieval.RetrievalModuleItem;
import de.ellpeck.prettypipes.pipe.modules.stacksize.StackSizeModuleContainer;
import de.ellpeck.prettypipes.pipe.modules.stacksize.StackSizeModuleGui;
import de.ellpeck.prettypipes.pipe.modules.stacksize.StackSizeModuleItem;
import de.ellpeck.prettypipes.pressurizer.PressurizerBlock;
import de.ellpeck.prettypipes.pressurizer.PressurizerBlockEntity;
import de.ellpeck.prettypipes.pressurizer.PressurizerContainer;
import de.ellpeck.prettypipes.pressurizer.PressurizerGui;
import de.ellpeck.prettypipes.terminal.CraftingTerminalBlock;
import de.ellpeck.prettypipes.terminal.CraftingTerminalBlockEntity;
import de.ellpeck.prettypipes.terminal.ItemTerminalBlock;
import de.ellpeck.prettypipes.terminal.ItemTerminalBlockEntity;
import de.ellpeck.prettypipes.terminal.containers.CraftingTerminalContainer;
import de.ellpeck.prettypipes.terminal.containers.CraftingTerminalGui;
import de.ellpeck.prettypipes.terminal.containers.ItemTerminalContainer;
import de.ellpeck.prettypipes.terminal.containers.ItemTerminalGui;
import java.util.Comparator;
import java.util.Locale;
import java.util.function.BiFunction;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;
import net.neoforged.neoforge.registries.RegisterEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public final class Registry {
    public static BlockCapability<IPipeConnectable, Direction> pipeConnectableCapability = BlockCapability.createSided((ResourceLocation)new ResourceLocation("prettypipes", "pipe_connectable"), IPipeConnectable.class);
    public static Item wrenchItem;
    public static Item pipeFrameItem;
    public static Block pipeBlock;
    public static BlockEntityType<PipeBlockEntity> pipeBlockEntity;
    public static MenuType<MainPipeContainer> pipeContainer;
    public static Block itemTerminalBlock;
    public static BlockEntityType<ItemTerminalBlockEntity> itemTerminalBlockEntity;
    public static MenuType<ItemTerminalContainer> itemTerminalContainer;
    public static Block craftingTerminalBlock;
    public static BlockEntityType<CraftingTerminalBlockEntity> craftingTerminalBlockEntity;
    public static MenuType<CraftingTerminalContainer> craftingTerminalContainer;
    public static EntityType<PipeFrameEntity> pipeFrameEntity;
    public static Block pressurizerBlock;
    public static BlockEntityType<PressurizerBlockEntity> pressurizerBlockEntity;
    public static MenuType<PressurizerContainer> pressurizerContainer;
    public static MenuType<ExtractionModuleContainer> extractionModuleContainer;
    public static MenuType<FilterModuleContainer> filterModuleContainer;
    public static MenuType<RetrievalModuleContainer> retrievalModuleContainer;
    public static MenuType<StackSizeModuleContainer> stackSizeModuleContainer;
    public static MenuType<FilterIncreaseModuleContainer> filterIncreaseModuleContainer;
    public static MenuType<CraftingModuleContainer> craftingModuleContainer;
    public static MenuType<FilterModifierModuleContainer> filterModifierModuleContainer;

    @SubscribeEvent
    public static void register(RegisterEvent event) {
        event.register(Registries.BLOCK, h -> {
            pipeBlock = new PipeBlock(BlockBehaviour.Properties.of().strength(2.0f).sound(SoundType.STONE).noOcclusion());
            h.register(new ResourceLocation("prettypipes", "pipe"), (Object)pipeBlock);
            itemTerminalBlock = new ItemTerminalBlock(BlockBehaviour.Properties.of().strength(3.0f).sound(SoundType.STONE));
            h.register(new ResourceLocation("prettypipes", "item_terminal"), (Object)itemTerminalBlock);
            craftingTerminalBlock = new CraftingTerminalBlock(BlockBehaviour.Properties.of().strength(3.0f).sound(SoundType.STONE));
            h.register(new ResourceLocation("prettypipes", "crafting_terminal"), (Object)craftingTerminalBlock);
            pressurizerBlock = new PressurizerBlock(BlockBehaviour.Properties.of().strength(3.0f).sound(SoundType.STONE));
            h.register(new ResourceLocation("prettypipes", "pressurizer"), (Object)pressurizerBlock);
        });
        event.register(Registries.ITEM, h -> {
            String name;
            wrenchItem = new WrenchItem();
            h.register(new ResourceLocation("prettypipes", "wrench"), (Object)wrenchItem);
            h.register(new ResourceLocation("prettypipes", "blank_module"), (Object)new Item(new Item.Properties()));
            pipeFrameItem = new PipeFrameItem();
            h.register(new ResourceLocation("prettypipes", "pipe_frame"), (Object)pipeFrameItem);
            h.register(new ResourceLocation("prettypipes", "stack_size_module"), (Object)new StackSizeModuleItem());
            h.register(new ResourceLocation("prettypipes", "redstone_module"), (Object)new RedstoneModuleItem());
            h.register(new ResourceLocation("prettypipes", "filter_increase_modifier"), (Object)new FilterIncreaseModuleItem());
            Registry.registerTieredModule((RegisterEvent.RegisterHelper<Item>)h, "extraction_module", ExtractionModuleItem::new);
            Registry.registerTieredModule((RegisterEvent.RegisterHelper<Item>)h, "filter_module", FilterModuleItem::new);
            Registry.registerTieredModule((RegisterEvent.RegisterHelper<Item>)h, "speed_module", SpeedModuleItem::new);
            Registry.registerTieredModule((RegisterEvent.RegisterHelper<Item>)h, "low_priority_module", LowPriorityModuleItem::new);
            Registry.registerTieredModule((RegisterEvent.RegisterHelper<Item>)h, "high_priority_module", HighPriorityModuleItem::new);
            Registry.registerTieredModule((RegisterEvent.RegisterHelper<Item>)h, "retrieval_module", RetrievalModuleItem::new);
            Registry.registerTieredModule((RegisterEvent.RegisterHelper<Item>)h, "crafting_module", CraftingModuleItem::new);
            for (ItemEquality.Type type : ItemEquality.Type.values()) {
                name = type.name().toLowerCase(Locale.ROOT) + "_filter_modifier";
                h.register(new ResourceLocation("prettypipes", name), (Object)new FilterModifierModuleItem(name, type));
            }
            for (Enum enum_ : SortingModuleItem.Type.values()) {
                name = enum_.name().toLowerCase(Locale.ROOT) + "_sorting_modifier";
                h.register(new ResourceLocation("prettypipes", name), (Object)new SortingModuleItem(name, (SortingModuleItem.Type)enum_));
            }
            BuiltInRegistries.BLOCK.entrySet().stream().filter(b -> ((ResourceKey)b.getKey()).location().getNamespace().equals("prettypipes")).forEach(b -> h.register(((ResourceKey)b.getKey()).location(), (Object)new BlockItem((Block)b.getValue(), new Item.Properties())));
        });
        event.register(Registries.BLOCK_ENTITY_TYPE, h -> {
            pipeBlockEntity = BlockEntityType.Builder.of(PipeBlockEntity::new, (Block[])new Block[]{pipeBlock}).build(null);
            h.register(new ResourceLocation("prettypipes", "pipe"), (Object)pipeBlockEntity);
            itemTerminalBlockEntity = BlockEntityType.Builder.of(ItemTerminalBlockEntity::new, (Block[])new Block[]{itemTerminalBlock}).build(null);
            h.register(new ResourceLocation("prettypipes", "item_terminal"), (Object)itemTerminalBlockEntity);
            craftingTerminalBlockEntity = BlockEntityType.Builder.of(CraftingTerminalBlockEntity::new, (Block[])new Block[]{craftingTerminalBlock}).build(null);
            h.register(new ResourceLocation("prettypipes", "crafting_terminal"), (Object)craftingTerminalBlockEntity);
            pressurizerBlockEntity = BlockEntityType.Builder.of(PressurizerBlockEntity::new, (Block[])new Block[]{pressurizerBlock}).build(null);
            h.register(new ResourceLocation("prettypipes", "pressurizer"), (Object)pressurizerBlockEntity);
        });
        event.register(Registries.ENTITY_TYPE, h -> {
            pipeFrameEntity = EntityType.Builder.of(PipeFrameEntity::new, (MobCategory)MobCategory.MISC).build("pipe_frame");
            h.register(new ResourceLocation("prettypipes", "pipe_frame"), (Object)pipeFrameEntity);
        });
        event.register(Registries.MENU, h -> {
            pipeContainer = IMenuTypeExtension.create((windowId, inv, data) -> new MainPipeContainer(pipeContainer, windowId, inv.player, data.readBlockPos()));
            h.register(new ResourceLocation("prettypipes", "pipe"), (Object)pipeContainer);
            itemTerminalContainer = IMenuTypeExtension.create((windowId, inv, data) -> new ItemTerminalContainer(itemTerminalContainer, windowId, inv.player, data.readBlockPos()));
            h.register(new ResourceLocation("prettypipes", "item_terminal"), (Object)itemTerminalContainer);
            craftingTerminalContainer = IMenuTypeExtension.create((windowId, inv, data) -> new CraftingTerminalContainer(craftingTerminalContainer, windowId, inv.player, data.readBlockPos()));
            h.register(new ResourceLocation("prettypipes", "crafting_terminal"), (Object)craftingTerminalContainer);
            pressurizerContainer = IMenuTypeExtension.create((windowId, inv, data) -> new PressurizerContainer(pressurizerContainer, windowId, inv.player, data.readBlockPos()));
            h.register(new ResourceLocation("prettypipes", "pressurizer"), (Object)pressurizerContainer);
            extractionModuleContainer = Registry.registerPipeContainer(h, "extraction_module");
            filterModuleContainer = Registry.registerPipeContainer(h, "filter_module");
            retrievalModuleContainer = Registry.registerPipeContainer(h, "retrieval_module");
            stackSizeModuleContainer = Registry.registerPipeContainer(h, "stack_size_module");
            filterIncreaseModuleContainer = Registry.registerPipeContainer(h, "filter_increase_module");
            craftingModuleContainer = Registry.registerPipeContainer(h, "crafting_module");
            filterModifierModuleContainer = Registry.registerPipeContainer(h, "filter_modifier_module");
        });
        event.register(BuiltInRegistries.CREATIVE_MODE_TAB.key(), h -> h.register(new ResourceLocation("prettypipes", "tab"), (Object)CreativeModeTab.builder().title((Component)Component.translatable((String)"item_group.prettypipes.tab")).icon(() -> new ItemStack((ItemLike)wrenchItem)).displayItems((params, output) -> BuiltInRegistries.ITEM.entrySet().stream().filter(b -> ((ResourceKey)b.getKey()).location().getNamespace().equals("prettypipes")).sorted(Comparator.comparing(b -> ((Item)b.getValue()).getClass().getSimpleName())).forEach(b -> output.accept((ItemLike)b.getValue()))).build()));
        event.register(Registries.RECIPE_SERIALIZER, h -> h.register(new ResourceLocation("prettypipes", "module_clearing"), ModuleClearingRecipe.SERIALIZER));
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(pipeConnectableCapability, pipeBlockEntity, (e, d) -> e);
        event.registerBlockEntity(pipeConnectableCapability, pressurizerBlockEntity, (e, d) -> e);
        event.registerBlockEntity(pipeConnectableCapability, itemTerminalBlockEntity, (e, d) -> e);
        event.registerBlockEntity(pipeConnectableCapability, craftingTerminalBlockEntity, (e, d) -> e);
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, pressurizerBlockEntity, (e, d) -> e.storage);
    }

    @SubscribeEvent
    public static void registerPayloads(RegisterPayloadHandlerEvent event) {
        IPayloadRegistrar registrar = event.registrar("prettypipes");
        registrar.play(PacketItemEnterPipe.ID, PacketItemEnterPipe::new, PacketItemEnterPipe::onMessage);
        registrar.play(PacketButton.ID, PacketButton::new, PacketButton::onMessage);
        registrar.play(PacketCraftingModuleTransfer.ID, PacketCraftingModuleTransfer::new, PacketCraftingModuleTransfer::onMessage);
        registrar.play(PacketGhostSlot.ID, PacketGhostSlot::new, PacketGhostSlot::onMessage);
        registrar.play(PacketNetworkItems.ID, PacketNetworkItems::new, PacketNetworkItems::onMessage);
        registrar.play(PacketRequest.ID, PacketRequest::new, PacketRequest::onMessage);
    }

    private static <T extends AbstractPipeContainer<?>> MenuType<T> registerPipeContainer(RegisterEvent.RegisterHelper<MenuType<?>> helper, String name) {
        MenuType type = IMenuTypeExtension.create((windowId, inv, data) -> {
            PipeBlockEntity tile = Utility.getBlockEntity(PipeBlockEntity.class, (BlockGetter)inv.player.level(), data.readBlockPos());
            int moduleIndex = data.readInt();
            ItemStack moduleStack = tile.modules.getStackInSlot(moduleIndex);
            return ((IModule)moduleStack.getItem()).getContainer(moduleStack, tile, windowId, inv, inv.player, moduleIndex);
        });
        helper.register(new ResourceLocation("prettypipes", name), (Object)type);
        return type;
    }

    private static void registerTieredModule(RegisterEvent.RegisterHelper<Item> helper, String name, BiFunction<String, ModuleTier, ModuleItem> item) {
        for (ModuleTier tier : ModuleTier.values()) {
            helper.register(new ResourceLocation("prettypipes", tier.name().toLowerCase(Locale.ROOT) + "_" + name), (Object)item.apply(name, tier));
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static final class Client {
        @SubscribeEvent
        public static void setup(FMLClientSetupEvent event) {
            BlockEntityRenderers.register(pipeBlockEntity, PipeRenderer::new);
            EntityRenderers.register(pipeFrameEntity, PipeFrameRenderer::new);
            MenuScreens.register(pipeContainer, MainPipeGui::new);
            MenuScreens.register(itemTerminalContainer, ItemTerminalGui::new);
            MenuScreens.register(pressurizerContainer, PressurizerGui::new);
            MenuScreens.register(craftingTerminalContainer, CraftingTerminalGui::new);
            MenuScreens.register(extractionModuleContainer, ExtractionModuleGui::new);
            MenuScreens.register(filterModuleContainer, FilterModuleGui::new);
            MenuScreens.register(retrievalModuleContainer, RetrievalModuleGui::new);
            MenuScreens.register(stackSizeModuleContainer, StackSizeModuleGui::new);
            MenuScreens.register(filterIncreaseModuleContainer, FilterIncreaseModuleGui::new);
            MenuScreens.register(craftingModuleContainer, CraftingModuleGui::new);
            MenuScreens.register(filterModifierModuleContainer, FilterModifierModuleGui::new);
        }
    }
}

