/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;
import org.apache.commons.lang3.tuple.Pair;

public final class Utility {
    public static <T extends BlockEntity> T getBlockEntity(Class<T> type, BlockGetter world, BlockPos pos) {
        BlockEntity tile = world.getBlockEntity(pos);
        return (T)(type.isInstance(tile) ? tile : null);
    }

    public static void dropInventory(BlockEntity tile, IItemHandler inventory) {
        BlockPos pos = tile.getBlockPos();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            Containers.dropItemStack((Level)tile.getLevel(), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
        }
    }

    public static Direction getDirectionFromOffset(BlockPos pos, BlockPos other) {
        BlockPos diff = pos.subtract((Vec3i)other);
        return Direction.fromDelta((int)diff.getX(), (int)diff.getY(), (int)diff.getZ());
    }

    public static void addTooltip(String name, List<Component> tooltip) {
        if (Screen.hasShiftDown()) {
            String[] content;
            for (String s : content = I18n.get((String)("info.prettypipes." + name), (Object[])new Object[0]).split("\n")) {
                tooltip.add((Component)Component.literal((String)s).setStyle(Style.EMPTY.applyFormat(ChatFormatting.GRAY)));
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"info.prettypipes.shift").setStyle(Style.EMPTY.applyFormat(ChatFormatting.DARK_GRAY)));
        }
    }

    public static ItemStack transferStackInSlot(AbstractContainerMenu container, IMergeItemStack merge, Player player, int slotIndex, Function<ItemStack, Pair<Integer, Integer>> predicate) {
        int inventoryStart = (int)container.slots.stream().filter(slot -> slot.container != player.getInventory()).count();
        int inventoryEnd = inventoryStart + 26;
        int hotbarStart = inventoryEnd + 1;
        int hotbarEnd = hotbarStart + 8;
        Slot slot2 = (Slot)container.slots.get(slotIndex);
        if (slot2 != null && slot2.hasItem()) {
            Pair<Integer, Integer> slots;
            ItemStack newStack = slot2.getItem();
            ItemStack currentStack = newStack.copy();
            if (slotIndex >= inventoryStart ? ((slots = predicate.apply(newStack)) != null ? !merge.mergeItemStack(newStack, (Integer)slots.getLeft(), (Integer)slots.getRight(), false) : (slotIndex >= inventoryStart && slotIndex <= inventoryEnd ? !merge.mergeItemStack(newStack, hotbarStart, hotbarEnd + 1, false) : slotIndex >= inventoryEnd + 1 && slotIndex < hotbarEnd + 1 && !merge.mergeItemStack(newStack, inventoryStart, inventoryEnd + 1, false))) : !merge.mergeItemStack(newStack, inventoryStart, hotbarEnd + 1, false)) {
                return ItemStack.EMPTY;
            }
            if (newStack.isEmpty()) {
                slot2.set(ItemStack.EMPTY);
            } else {
                slot2.setChanged();
            }
            if (newStack.getCount() == currentStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot2.onTake(player, newStack);
            return currentStack;
        }
        return ItemStack.EMPTY;
    }

    public static ListTag serializeAll(Collection<? extends INBTSerializable<CompoundTag>> items) {
        ListTag list = new ListTag();
        for (INBTSerializable<CompoundTag> iNBTSerializable : items) {
            list.add((Object)iNBTSerializable.serializeNBT());
        }
        return list;
    }

    public static void sendBlockEntityToClients(BlockEntity tile) {
        ServerLevel world = (ServerLevel)tile.getLevel();
        List entities = world.getChunkSource().chunkMap.getPlayers(new ChunkPos(tile.getBlockPos()), false);
        ClientboundBlockEntityDataPacket packet = ClientboundBlockEntityDataPacket.create((BlockEntity)tile, BlockEntity::saveWithoutMetadata);
        for (ServerPlayer e : entities) {
            e.connection.send((Packet)packet);
        }
    }

    public static <T extends INBTSerializable<CompoundTag>> List<T> deserializeAll(ListTag list, Function<CompoundTag, T> supplier) {
        ArrayList<INBTSerializable> items = new ArrayList<INBTSerializable>();
        for (int i = 0; i < list.size(); ++i) {
            INBTSerializable item = (INBTSerializable)supplier.apply(list.getCompound(i));
            if (item == null) continue;
            items.add(item);
        }
        return items;
    }

    public static IItemHandler getBlockItemHandler(Level world, BlockPos pos, Direction direction) {
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (!(block instanceof WorldlyContainerHolder)) {
            return null;
        }
        WorldlyContainerHolder holder = (WorldlyContainerHolder)block;
        WorldlyContainer inventory = holder.getContainer(state, (LevelAccessor)world, pos);
        if (inventory == null) {
            return null;
        }
        return new SidedInvWrapper(inventory, direction);
    }

    public static interface IMergeItemStack {
        public boolean mergeItemStack(ItemStack var1, int var2, int var3, boolean var4);
    }
}

