/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.misc;

import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.packets.PacketButton;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import org.apache.commons.lang3.ArrayUtils;

public class DirectionSelector {
    private static final Direction[] ALL = (Direction[])ArrayUtils.addAll((Object[])Direction.values(), (Object[])new Direction[]{null});
    private Direction direction;
    private boolean modified;
    private final ItemStack stack;
    private final PipeBlockEntity pipe;

    public DirectionSelector(ItemStack stack, PipeBlockEntity pipe) {
        this.stack = stack;
        this.pipe = pipe;
        this.load();
    }

    @OnlyIn(value=Dist.CLIENT)
    public AbstractWidget getButton(int x, int y) {
        return new ExtendedButton(x, y, 100, 20, (Component)Component.translatable((String)"info.prettypipes.populate"), button -> PacketButton.sendAndExecute(this.pipe.getBlockPos(), PacketButton.ButtonResult.DIRECTION_SELECTOR, new int[0])){

            public Component getMessage() {
                PipeBlockEntity pipe = DirectionSelector.this.pipe;
                Direction dir = DirectionSelector.this.direction;
                MutableComponent msg = Component.translatable((String)("dir.prettypipes." + (dir != null ? dir.getName() : "all")));
                if (dir != null) {
                    MutableComponent blockName;
                    MutableComponent mutableComponent = blockName = pipe.getItemHandler(dir) != null ? pipe.getLevel().getBlockState(pipe.getBlockPos().relative(dir)).getBlock().getName() : null;
                    if (blockName != null) {
                        msg = msg.append(" (").append((Component)blockName).append(")");
                    }
                }
                return msg;
            }
        };
    }

    public void onButtonPacket() {
        Direction dir = this.direction;
        while (!this.isDirectionValid(dir = ALL[(ArrayUtils.indexOf((Object[])ALL, (Object)dir) + 1) % ALL.length])) {
        }
        if (this.direction != dir) {
            this.direction = dir;
            this.modified = true;
        }
    }

    public void save() {
        if (!this.modified) {
            return;
        }
        this.modified = false;
        CompoundTag tag = new CompoundTag();
        if (this.direction != null) {
            tag.putString("direction", this.direction.getName());
        }
        this.stack.getOrCreateTag().put("direction_selector", (Tag)tag);
    }

    public void load() {
        if (this.stack.hasTag()) {
            CompoundTag tag = this.stack.getTag().getCompound("direction_selector");
            this.direction = Direction.byName((String)tag.getString("direction"));
        }
    }

    public Direction[] directions() {
        Direction[] directionArray;
        if (this.direction != null) {
            Direction[] directionArray2 = new Direction[1];
            directionArray = directionArray2;
            directionArray2[0] = this.direction;
        } else {
            directionArray = Direction.values();
        }
        return directionArray;
    }

    public boolean has(Direction dir) {
        return this.direction == null || this.direction == dir;
    }

    private boolean isDirectionValid(Direction dir) {
        if (dir == null) {
            return true;
        }
        if (this.pipe.getItemHandler(dir) == null) {
            return false;
        }
        return this.pipe.streamModules().filter(p -> p.getLeft() != this.stack).map(p -> ((IModule)p.getRight()).getDirectionSelector((ItemStack)p.getLeft(), this.pipe)).noneMatch(p -> p != null && p.direction == dir);
    }

    public static interface IDirectionContainer {
        public DirectionSelector getSelector();
    }
}

