/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.misc;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.ellpeck.prettypipes.network.PipeNetwork;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.server.ServerStartingEvent;

@Mod.EventBusSubscriber
public final class Events {
    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        event.getServer().getCommands().getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"prettypipes").requires(s -> s.hasPermission(2))).then(Commands.literal((String)"dump").executes(c -> {
            CommandSourceStack source = (CommandSourceStack)c.getSource();
            Path file = Paths.get("_prettypipesdump.txt", new String[0]);
            String dump = PipeNetwork.get((Level)source.getLevel()).toString();
            try {
                Files.writeString(file, (CharSequence)dump, StandardCharsets.UTF_8, new OpenOption[0]);
                source.sendSuccess(() -> Component.literal((String)("Wrote network dump to file " + file.toAbsolutePath())), true);
            }
            catch (IOException e) {
                source.sendFailure((Component)Component.literal((String)("Failed to write network dump to file " + file.toAbsolutePath())));
                return -1;
            }
            return 0;
        }))).then(Commands.literal((String)"uncache").executes(c -> {
            CommandSourceStack source = (CommandSourceStack)c.getSource();
            PipeNetwork.get((Level)source.getLevel()).clearCaches();
            source.sendSuccess(() -> Component.literal((String)"Cleared all pipe caches in the world"), true);
            return 0;
        }))).then(Commands.literal((String)"unlock").executes(c -> {
            CommandSourceStack source = (CommandSourceStack)c.getSource();
            PipeNetwork.get((Level)source.getLevel()).unlock();
            source.sendSuccess(() -> Component.literal((String)"Resolved all network locks in the world"), true);
            return 0;
        })));
    }
}

