/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.misc;

import de.ellpeck.prettypipes.items.IModule;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ModuleClearingRecipe
extends CustomRecipe {
    public static final RecipeSerializer<ModuleClearingRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(ModuleClearingRecipe::new);

    public ModuleClearingRecipe(CraftingBookCategory cat) {
        super(cat);
    }

    public boolean matches(CraftingContainer container, Level level) {
        boolean foundModule = false;
        for (ItemStack stack : container.getItems()) {
            if (!foundModule && stack.getItem() instanceof IModule) {
                foundModule = true;
                continue;
            }
            if (stack.isEmpty()) continue;
            return false;
        }
        return foundModule;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess access) {
        ItemStack module = container.getItems().stream().filter(i -> i.getItem() instanceof IModule).findFirst().orElse(ItemStack.EMPTY);
        if (!module.isEmpty()) {
            module = new ItemStack((ItemLike)module.getItem());
        }
        return module;
    }

    public boolean canCraftInDimensions(int x, int y) {
        return x >= 1 && y >= 1;
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }
}

