/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.network;

import de.ellpeck.prettypipes.misc.ItemEquality;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandler;

public class NetworkLocation
implements INBTSerializable<CompoundTag> {
    public BlockPos pipePos;
    public Direction direction;
    private Map<Integer, ItemStack> itemCache;
    private IItemHandler handlerCache;

    public NetworkLocation(BlockPos pipePos, Direction direction) {
        this.pipePos = pipePos;
        this.direction = direction;
    }

    public NetworkLocation(CompoundTag nbt) {
        this.deserializeNBT(nbt);
    }

    public List<Integer> getStackSlots(Level world, ItemStack stack, ItemEquality ... equalityTypes) {
        if (this.isEmpty(world)) {
            return Collections.emptyList();
        }
        return this.getItems(world).entrySet().stream().filter(kv -> ItemEquality.compareItems((ItemStack)kv.getValue(), stack, equalityTypes) && this.canExtract(world, (Integer)kv.getKey())).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public int getItemAmount(Level world, ItemStack stack, ItemEquality ... equalityTypes) {
        if (this.isEmpty(world)) {
            return 0;
        }
        return this.getItems(world).entrySet().stream().filter(kv -> ItemEquality.compareItems(stack, (ItemStack)kv.getValue(), equalityTypes) && this.canExtract(world, (Integer)kv.getKey())).mapToInt(kv -> ((ItemStack)kv.getValue()).getCount()).sum();
    }

    public Map<Integer, ItemStack> getItems(Level world) {
        IItemHandler handler;
        if (this.itemCache == null && (handler = this.getItemHandler(world)) != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                if (this.itemCache == null) {
                    this.itemCache = new HashMap<Integer, ItemStack>();
                }
                this.itemCache.put(i, stack);
            }
        }
        return this.itemCache;
    }

    public boolean canExtract(Level world, int slot) {
        IItemHandler handler = this.getItemHandler(world);
        return handler != null && !handler.extractItem(slot, 1, true).isEmpty();
    }

    public IItemHandler getItemHandler(Level world) {
        if (this.handlerCache == null) {
            PipeNetwork network = PipeNetwork.get(world);
            PipeBlockEntity pipe = network.getPipe(this.pipePos);
            this.handlerCache = pipe.getItemHandler(this.direction);
        }
        return this.handlerCache;
    }

    public boolean isEmpty(Level world) {
        Map<Integer, ItemStack> items = this.getItems(world);
        return items == null || items.isEmpty();
    }

    public BlockPos getPos() {
        return this.pipePos.relative(this.direction);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.put("pipe_pos", (Tag)NbtUtils.writeBlockPos((BlockPos)this.pipePos));
        nbt.putInt("direction", this.direction.ordinal());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.pipePos = NbtUtils.readBlockPos((CompoundTag)nbt.getCompound("pipe_pos"));
        this.direction = Direction.values()[nbt.getInt("direction")];
    }
}

