/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.packets;

import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.misc.DirectionSelector;
import de.ellpeck.prettypipes.misc.ItemFilter;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import de.ellpeck.prettypipes.pipe.containers.AbstractPipeContainer;
import de.ellpeck.prettypipes.pipe.modules.modifier.FilterModifierModuleContainer;
import de.ellpeck.prettypipes.pipe.modules.modifier.FilterModifierModuleItem;
import de.ellpeck.prettypipes.pipe.modules.stacksize.StackSizeModuleItem;
import de.ellpeck.prettypipes.terminal.CraftingTerminalBlockEntity;
import de.ellpeck.prettypipes.terminal.ItemTerminalBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.apache.logging.log4j.util.TriConsumer;

public class PacketButton
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("prettypipes", "button");
    private final BlockPos pos;
    private final ButtonResult result;
    private final int[] data;

    public PacketButton(BlockPos pos, ButtonResult result, int ... data) {
        this.pos = pos;
        this.result = result;
        this.data = data;
    }

    public PacketButton(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.result = ButtonResult.values()[buf.readByte()];
        this.data = buf.readVarIntArray();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeByte(this.result.ordinal());
        buf.writeVarIntArray(this.data);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void onMessage(PacketButton message, PlayPayloadContext ctx) {
        ctx.workHandler().execute(() -> {
            Player player = (Player)ctx.player().orElseThrow();
            message.result.action.accept((Object)message.pos, (Object)message.data, (Object)player);
        });
    }

    public static void sendAndExecute(BlockPos pos, ButtonResult result, int ... data) {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new PacketButton(pos, result, data)});
        result.action.accept((Object)pos, (Object)data, (Object)Minecraft.getInstance().player);
    }

    public static enum ButtonResult {
        PIPE_TAB((TriConsumer<BlockPos, int[], Player>)((TriConsumer)(pos, data, player) -> {
            final PipeBlockEntity tile = Utility.getBlockEntity(PipeBlockEntity.class, (BlockGetter)player.level(), pos);
            if (data[0] < 0) {
                player.openMenu((MenuProvider)tile, pos);
            } else {
                final ItemStack stack = tile.modules.getStackInSlot(data[0]);
                player.openMenu(new MenuProvider(){
                    final /* synthetic */ int[] val$data;
                    {
                        this.val$data = nArray;
                    }

                    public Component getDisplayName() {
                        return stack.getHoverName();
                    }

                    @Nullable
                    public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
                        return ((IModule)stack.getItem()).getContainer(stack, tile, windowId, inv, player, this.val$data[0]);
                    }
                }, buf -> {
                    buf.writeBlockPos(pos);
                    buf.writeInt(data[0]);
                });
            }
        })),
        FILTER_CHANGE((TriConsumer<BlockPos, int[], Player>)((TriConsumer)(pos, data, player) -> {
            AbstractContainerMenu patt4115$temp = player.containerMenu;
            if (patt4115$temp instanceof ItemFilter.IFilteredContainer) {
                ItemFilter.IFilteredContainer filtered = (ItemFilter.IFilteredContainer)patt4115$temp;
                filtered.getFilter().onButtonPacket(filtered, data[0]);
            }
        })),
        STACK_SIZE_MODULE_BUTTON((TriConsumer<BlockPos, int[], Player>)((TriConsumer)(pos, data, player) -> {
            AbstractPipeContainer container = (AbstractPipeContainer)player.containerMenu;
            StackSizeModuleItem.setLimitToMaxStackSize(container.moduleStack, !StackSizeModuleItem.getLimitToMaxStackSize(container.moduleStack));
        })),
        STACK_SIZE_AMOUNT((TriConsumer<BlockPos, int[], Player>)((TriConsumer)(pos, data, player) -> {
            AbstractPipeContainer container = (AbstractPipeContainer)player.containerMenu;
            StackSizeModuleItem.setMaxStackSize(container.moduleStack, data[0]);
        })),
        CRAFT_TERMINAL_REQUEST((TriConsumer<BlockPos, int[], Player>)((TriConsumer)(pos, data, player) -> {
            CraftingTerminalBlockEntity tile = Utility.getBlockEntity(CraftingTerminalBlockEntity.class, (BlockGetter)player.level(), pos);
            tile.requestCraftingItems((Player)player, data[0], data[1] > 0);
        })),
        CANCEL_CRAFTING((TriConsumer<BlockPos, int[], Player>)((TriConsumer)(pos, data, player) -> {
            ItemTerminalBlockEntity tile = Utility.getBlockEntity(ItemTerminalBlockEntity.class, (BlockGetter)player.level(), pos);
            tile.cancelCrafting();
        })),
        TAG_FILTER((TriConsumer<BlockPos, int[], Player>)((TriConsumer)(pos, data, player) -> {
            FilterModifierModuleContainer container = (FilterModifierModuleContainer)player.containerMenu;
            FilterModifierModuleItem.setFilterTag(container.moduleStack, container.getTags().get(data[0]));
        })),
        DIRECTION_SELECTOR((TriConsumer<BlockPos, int[], Player>)((TriConsumer)(pos, data, player) -> {
            AbstractContainerMenu patt5548$temp = player.containerMenu;
            if (patt5548$temp instanceof DirectionSelector.IDirectionContainer) {
                DirectionSelector.IDirectionContainer filtered = (DirectionSelector.IDirectionContainer)patt5548$temp;
                filtered.getSelector().onButtonPacket();
            }
        }));

        public final TriConsumer<BlockPos, int[], Player> action;

        private ButtonResult(TriConsumer<BlockPos, int[], Player> action) {
            this.action = action;
        }
    }
}

