/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.packets;

import de.ellpeck.prettypipes.pipe.modules.craft.CraftingModuleContainer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class PacketCraftingModuleTransfer
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("prettypipes", "crafting_module_transfer");
    private final List<ItemStack> inputs;
    private final List<ItemStack> outputs;

    public PacketCraftingModuleTransfer(List<ItemStack> inputs, List<ItemStack> outputs) {
        this.inputs = inputs;
        this.outputs = outputs;
    }

    public PacketCraftingModuleTransfer(FriendlyByteBuf buf) {
        int i;
        this.inputs = new ArrayList<ItemStack>();
        for (i = buf.readInt(); i > 0; --i) {
            this.inputs.add(buf.readItem());
        }
        this.outputs = new ArrayList<ItemStack>();
        for (i = buf.readInt(); i > 0; --i) {
            this.outputs.add(buf.readItem());
        }
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.inputs.size());
        for (ItemStack stack : this.inputs) {
            buf.writeItem(stack);
        }
        buf.writeInt(this.outputs.size());
        for (ItemStack stack : this.outputs) {
            buf.writeItem(stack);
        }
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void onMessage(PacketCraftingModuleTransfer message, PlayPayloadContext ctx) {
        ctx.workHandler().execute(() -> {
            Player player = (Player)ctx.player().orElseThrow();
            AbstractContainerMenu patt2056$temp = player.containerMenu;
            if (patt2056$temp instanceof CraftingModuleContainer) {
                CraftingModuleContainer container = (CraftingModuleContainer)patt2056$temp;
                PacketCraftingModuleTransfer.copy(container.input, message.inputs);
                PacketCraftingModuleTransfer.copy(container.output, message.outputs);
                container.modified = true;
                container.broadcastChanges();
            }
        });
    }

    private static void copy(ItemStackHandler container, List<ItemStack> contents) {
        for (int i = 0; i < container.getSlots(); ++i) {
            container.setStackInSlot(i, ItemStack.EMPTY);
        }
        for (ItemStack stack : contents) {
            ItemHandlerHelper.insertItem((IItemHandler)container, (ItemStack)stack, (boolean)false);
        }
    }
}

