/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.packets;

import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.pipe.IPipeItem;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class PacketItemEnterPipe
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("prettypipes", "item_enter_pipe");
    private final BlockPos tilePos;
    private final CompoundTag item;

    public PacketItemEnterPipe(BlockPos tilePos, IPipeItem item) {
        this.tilePos = tilePos;
        this.item = (CompoundTag)item.serializeNBT();
    }

    public PacketItemEnterPipe(FriendlyByteBuf buf) {
        this.tilePos = buf.readBlockPos();
        this.item = buf.readNbt();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.tilePos);
        buf.writeNbt((Tag)this.item);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void onMessage(PacketItemEnterPipe message, PlayPayloadContext ctx) {
        ctx.workHandler().execute(() -> {
            Minecraft mc = Minecraft.getInstance();
            if (mc.level == null) {
                return;
            }
            IPipeItem item = IPipeItem.load(message.item);
            PipeBlockEntity pipe = Utility.getBlockEntity(PipeBlockEntity.class, (BlockGetter)mc.level, message.tilePos);
            if (pipe != null) {
                pipe.getItems().add(item);
            }
        });
    }
}

