/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.packets;

import de.ellpeck.prettypipes.terminal.containers.ItemTerminalGui;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class PacketNetworkItems
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("prettypipes", "network_items");
    private final List<ItemStack> items;
    private final List<ItemStack> craftables;
    private final List<ItemStack> currentlyCrafting;

    public PacketNetworkItems(List<ItemStack> items, List<ItemStack> craftables, List<ItemStack> currentlyCrafting) {
        this.items = items;
        this.craftables = craftables;
        this.currentlyCrafting = currentlyCrafting;
    }

    public PacketNetworkItems(FriendlyByteBuf buf) {
        int i;
        this.items = new ArrayList<ItemStack>();
        for (i = buf.readVarInt(); i > 0; --i) {
            ItemStack stack = buf.readItem();
            stack.setCount(buf.readVarInt());
            this.items.add(stack);
        }
        this.craftables = new ArrayList<ItemStack>();
        for (i = buf.readVarInt(); i > 0; --i) {
            this.craftables.add(buf.readItem());
        }
        this.currentlyCrafting = new ArrayList<ItemStack>();
        for (i = buf.readVarInt(); i > 0; --i) {
            this.currentlyCrafting.add(buf.readItem());
        }
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeVarInt(this.items.size());
        for (ItemStack stack : this.items) {
            ItemStack copy = stack.copy();
            copy.setCount(1);
            buf.writeItem(copy);
            buf.writeVarInt(stack.getCount());
        }
        buf.writeVarInt(this.craftables.size());
        for (ItemStack stack : this.craftables) {
            buf.writeItem(stack);
        }
        buf.writeVarInt(this.currentlyCrafting.size());
        for (ItemStack stack : this.currentlyCrafting) {
            buf.writeItem(stack);
        }
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void onMessage(final PacketNetworkItems message, PlayPayloadContext ctx) {
        ctx.workHandler().execute(new Runnable(){

            @Override
            public void run() {
                Minecraft mc = Minecraft.getInstance();
                Screen screen = mc.screen;
                if (screen instanceof ItemTerminalGui) {
                    ItemTerminalGui terminal = (ItemTerminalGui)screen;
                    terminal.updateItemList(message.items, message.craftables, message.currentlyCrafting);
                }
            }
        });
    }
}

