/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.packets;

import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.terminal.ItemTerminalBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class PacketRequest
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("prettypipes", "request");
    private final BlockPos pos;
    private final ItemStack stack;
    private final int nbtHash;
    private final int amount;

    public PacketRequest(BlockPos pos, ItemStack stack, int amount) {
        this.pos = pos;
        this.stack = stack;
        this.nbtHash = stack.hasTag() ? stack.getTag().hashCode() : 0;
        this.amount = amount;
    }

    public PacketRequest(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.stack = buf.readItem();
        this.nbtHash = buf.readVarInt();
        this.amount = buf.readVarInt();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeItem(this.stack);
        buf.writeVarInt(this.nbtHash);
        buf.writeVarInt(this.amount);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void onMessage(final PacketRequest message, final PlayPayloadContext ctx) {
        ctx.workHandler().execute(new Runnable(){

            @Override
            public void run() {
                Player player = (Player)ctx.player().orElseThrow();
                ItemTerminalBlockEntity tile = Utility.getBlockEntity(ItemTerminalBlockEntity.class, (BlockGetter)player.level(), message.pos);
                message.stack.setCount(message.amount);
                tile.requestItem(player, message.stack, message.nbtHash);
            }
        });
    }
}

