/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.pipe;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.network.NetworkLock;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.ConnectionType;
import de.ellpeck.prettypipes.pipe.IPipeConnectable;
import de.ellpeck.prettypipes.pipe.IPipeItem;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class PipeBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<PipeBlock> CODEC = BlockBehaviour.simpleCodec(PipeBlock::new);
    public static final Map<Direction, EnumProperty<ConnectionType>> DIRECTIONS = new HashMap<Direction, EnumProperty<ConnectionType>>();
    private static final Map<Pair<BlockState, BlockState>, VoxelShape> SHAPE_CACHE = new HashMap<Pair<BlockState, BlockState>, VoxelShape>();
    private static final Map<Pair<BlockState, BlockState>, VoxelShape> COLL_SHAPE_CACHE = new HashMap<Pair<BlockState, BlockState>, VoxelShape>();
    private static final VoxelShape CENTER_SHAPE = Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    public static final Map<Direction, VoxelShape> DIR_SHAPES = ImmutableMap.builder().put((Object)Direction.UP, (Object)Block.box((double)5.0, (double)10.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0)).put((Object)Direction.DOWN, (Object)Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0)).put((Object)Direction.NORTH, (Object)Block.box((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)6.0)).put((Object)Direction.SOUTH, (Object)Block.box((double)5.0, (double)5.0, (double)10.0, (double)11.0, (double)11.0, (double)16.0)).put((Object)Direction.EAST, (Object)Block.box((double)10.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0)).put((Object)Direction.WEST, (Object)Block.box((double)0.0, (double)5.0, (double)5.0, (double)6.0, (double)11.0, (double)11.0)).build();

    public PipeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        for (EnumProperty<ConnectionType> prop : DIRECTIONS.values()) {
            state = (BlockState)state.setValue(prop, (Comparable)((Object)ConnectionType.DISCONNECTED));
        }
        this.registerDefaultState(state);
    }

    public InteractionResult use(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult result) {
        PipeBlockEntity tile = Utility.getBlockEntity(PipeBlockEntity.class, (BlockGetter)worldIn, pos);
        if (tile == null) {
            return InteractionResult.PASS;
        }
        if (!tile.canHaveModules()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.getItemInHand(handIn);
        if (stack.getItem() instanceof IModule) {
            ItemStack copy = stack.copy();
            copy.setCount(1);
            ItemStack remain = ItemHandlerHelper.insertItem((IItemHandler)tile.modules, (ItemStack)copy, (boolean)false);
            if (remain.isEmpty()) {
                stack.shrink(1);
                return InteractionResult.SUCCESS;
            }
        } else if (handIn == InteractionHand.MAIN_HAND && stack.isEmpty()) {
            if (!worldIn.isClientSide) {
                player.openMenu((MenuProvider)tile, pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add((Property[])DIRECTIONS.values().toArray(new EnumProperty[0]));
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockState newState = this.createState(worldIn, pos, state);
        if (newState != state) {
            worldIn.setBlockAndUpdate(pos, newState);
            PipeBlock.onStateChanged(worldIn, pos, newState);
        }
    }

    @javax.annotation.Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.createState(context.getLevel(), context.getClickedPos(), this.defaultBlockState());
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, @javax.annotation.Nullable LivingEntity placer, ItemStack stack) {
        PipeBlock.onStateChanged(worldIn, pos, state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.cacheAndGetShape(state, worldIn, pos, s -> s.getShape(worldIn, pos, context), SHAPE_CACHE, null);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.cacheAndGetShape(state, worldIn, pos, s -> s.getCollisionShape(worldIn, pos, context), COLL_SHAPE_CACHE, s -> {
            MutableObject newShape = new MutableObject((Object)Shapes.empty());
            s.forAllBoxes((x1, y1, z1, x2, y2, z2) -> newShape.setValue((Object)Shapes.join((VoxelShape)Shapes.create((double)x1, (double)y1, (double)z1, (double)x2, (double)(y2 + 0.1875), (double)z2), (VoxelShape)((VoxelShape)newShape.getValue()), (BooleanOp)BooleanOp.OR)));
            return ((VoxelShape)newShape.getValue()).optimize();
        });
    }

    private VoxelShape cacheAndGetShape(BlockState state, BlockGetter worldIn, BlockPos pos, Function<BlockState, VoxelShape> coverShapeSelector, Map<Pair<BlockState, BlockState>, VoxelShape> cache, Function<VoxelShape, VoxelShape> shapeModifier) {
        Pair key;
        VoxelShape shape;
        VoxelShape coverShape = null;
        BlockState cover = null;
        PipeBlockEntity tile = Utility.getBlockEntity(PipeBlockEntity.class, worldIn, pos);
        if (tile != null && tile.cover != null) {
            cover = tile.cover;
            try {
                coverShape = coverShapeSelector.apply(cover);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((shape = cache.get(key = Pair.of((Object)state, cover))) == null) {
            shape = CENTER_SHAPE;
            for (Map.Entry<Direction, EnumProperty<ConnectionType>> entry : DIRECTIONS.entrySet()) {
                if (!((ConnectionType)((Object)state.getValue((Property)entry.getValue()))).isConnected()) continue;
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)DIR_SHAPES.get(entry.getKey()));
            }
            if (shapeModifier != null) {
                shape = shapeModifier.apply(shape);
            }
            if (coverShape != null) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)coverShape);
            }
            cache.put((Pair<BlockState, BlockState>)key, shape);
        }
        return shape;
    }

    private BlockState createState(Level world, BlockPos pos, BlockState curr) {
        BlockState state = this.defaultBlockState();
        FluidState fluid = world.getFluidState(pos);
        if (fluid.is(FluidTags.WATER) && fluid.getAmount() == 8) {
            state = (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        for (Direction dir : Direction.values()) {
            EnumProperty<ConnectionType> prop = DIRECTIONS.get(dir);
            ConnectionType type = this.getConnectionType(world, pos, dir, state);
            if (type.isConnected() && curr.getValue(prop) == ConnectionType.BLOCKED) {
                type = ConnectionType.BLOCKED;
            }
            state = (BlockState)state.setValue(prop, (Comparable)((Object)type));
        }
        return state;
    }

    protected ConnectionType getConnectionType(Level world, BlockPos pos, Direction direction, BlockState state) {
        IItemHandler blockHandler;
        BlockPos offset = pos.relative(direction);
        if (!world.isLoaded(offset)) {
            return ConnectionType.DISCONNECTED;
        }
        Direction opposite = direction.getOpposite();
        BlockEntity tile = world.getBlockEntity(offset);
        if (tile != null) {
            IPipeConnectable connectable = (IPipeConnectable)world.getCapability(Registry.pipeConnectableCapability, offset, tile.getBlockState(), tile, (Object)opposite);
            if (connectable != null) {
                return connectable.getConnectionType(pos, direction);
            }
            IItemHandler handler = (IItemHandler)world.getCapability(Capabilities.ItemHandler.BLOCK, offset, tile.getBlockState(), tile, (Object)opposite);
            if (handler != null) {
                return ConnectionType.CONNECTED;
            }
        }
        if ((blockHandler = Utility.getBlockItemHandler(world, offset, opposite)) != null) {
            return ConnectionType.CONNECTED;
        }
        BlockState offState = world.getBlockState(offset);
        if (PipeBlock.hasLegsTo(world, offState, offset, direction) && DIRECTIONS.values().stream().noneMatch(d -> state.getValue((Property)d) == ConnectionType.LEGS)) {
            return ConnectionType.LEGS;
        }
        return ConnectionType.DISCONNECTED;
    }

    protected static boolean hasLegsTo(Level world, BlockState state, BlockPos pos, Direction direction) {
        if (state.getBlock() instanceof WallBlock || state.getBlock() instanceof FenceBlock) {
            return direction == Direction.DOWN;
        }
        MapColor mapColor = state.getMapColor((BlockGetter)world, pos);
        if (mapColor == MapColor.STONE || mapColor == MapColor.METAL) {
            return Block.canSupportCenter((LevelReader)world, (BlockPos)pos, (Direction)direction.getOpposite());
        }
        return false;
    }

    public static void onStateChanged(Level world, BlockPos pos, BlockState newState) {
        PipeBlockEntity tile = Utility.getBlockEntity(PipeBlockEntity.class, (BlockGetter)world, pos);
        if (tile != null) {
            tile.moduleDropCheck = 5;
        }
        PipeNetwork network = PipeNetwork.get(world);
        int connections = 0;
        boolean force = false;
        for (Direction dir : Direction.values()) {
            ConnectionType value = (ConnectionType)((Object)newState.getValue((Property)DIRECTIONS.get(dir)));
            if (!value.isConnected()) continue;
            ++connections;
            BlockState otherState = world.getBlockState(pos.relative(dir));
            if (otherState.getBlock() == newState.getBlock()) continue;
            force = true;
            break;
        }
        if (force || connections > 2) {
            network.addNode(pos, newState);
        } else {
            network.removeNode(pos);
        }
        network.onPipeChanged(pos, newState);
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            PipeNetwork network = PipeNetwork.get(worldIn);
            network.removeNode(pos);
            network.onPipeChanged(pos, state);
            BlockEntity blockEntity = worldIn.getBlockEntity(pos);
            if (blockEntity instanceof PipeBlockEntity) {
                PipeBlockEntity pipe = (PipeBlockEntity)blockEntity;
                pipe.getItems().clear();
                for (NetworkLock lock : pipe.craftIngredientRequests) {
                    network.resolveNetworkLock(lock);
                }
            }
            super.onRemove(state, worldIn, pos, newState, isMoving);
        }
    }

    public BlockState playerWillDestroy(Level worldIn, BlockPos pos, BlockState state, Player player) {
        PipeBlock.dropItems(worldIn, pos, player);
        return super.playerWillDestroy(worldIn, pos, state, player);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        PipeBlockEntity pipe = Utility.getBlockEntity(PipeBlockEntity.class, (BlockGetter)world, pos);
        if (pipe == null) {
            return 0;
        }
        return Math.min(15, pipe.getItems().size());
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PipeBlockEntity(pos, state);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return BaseEntityBlock.createTickerHelper(type, Registry.pipeBlockEntity, PipeBlockEntity::tick);
    }

    public static void dropItems(Level worldIn, BlockPos pos, Player player) {
        PipeBlockEntity tile = Utility.getBlockEntity(PipeBlockEntity.class, (BlockGetter)worldIn, pos);
        if (tile != null) {
            Utility.dropInventory(tile, (IItemHandler)tile.modules);
            for (IPipeItem item : tile.getItems()) {
                item.drop(worldIn, item.getContent());
            }
            if (tile.cover != null) {
                tile.removeCover(player, InteractionHand.MAIN_HAND);
            }
        }
    }

    static {
        for (Direction dir : Direction.values()) {
            DIRECTIONS.put(dir, (EnumProperty<ConnectionType>)EnumProperty.create((String)dir.getName(), ConnectionType.class));
        }
    }
}

