/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.pipe;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.misc.DirectionSelector;
import de.ellpeck.prettypipes.misc.ItemEquality;
import de.ellpeck.prettypipes.misc.ItemFilter;
import de.ellpeck.prettypipes.network.NetworkLock;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.ConnectionType;
import de.ellpeck.prettypipes.pipe.IPipeConnectable;
import de.ellpeck.prettypipes.pipe.IPipeItem;
import de.ellpeck.prettypipes.pipe.PipeBlock;
import de.ellpeck.prettypipes.pipe.containers.MainPipeContainer;
import de.ellpeck.prettypipes.pressurizer.PressurizerBlockEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class PipeBlockEntity
extends BlockEntity
implements MenuProvider,
IPipeConnectable {
    public final ItemStackHandler modules = new ItemStackHandler(3){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            Item item = stack.getItem();
            if (!(item instanceof IModule)) {
                return false;
            }
            IModule module = (IModule)item;
            return PipeBlockEntity.this.streamModules().allMatch(m -> module.isCompatible(stack, PipeBlockEntity.this, (IModule)m.getRight()) && ((IModule)m.getRight()).isCompatible((ItemStack)m.getLeft(), PipeBlockEntity.this, module));
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            PipeBlockEntity.this.setChanged();
        }
    };
    public final Queue<NetworkLock> craftIngredientRequests = new LinkedList<NetworkLock>();
    public final List<Pair<BlockPos, ItemStack>> craftResultRequests = new ArrayList<Pair<BlockPos, ItemStack>>();
    public PressurizerBlockEntity pressurizer;
    public BlockState cover;
    public int moduleDropCheck;
    protected List<IPipeItem> items;
    private int lastItemAmount;
    private int priority;
    private final Lazy<Integer> workRandomizer = Lazy.of(() -> this.level.random.nextInt(200));

    public PipeBlockEntity(BlockPos pos, BlockState state) {
        super(Registry.pipeBlockEntity, pos, state);
    }

    public PipeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void onChunkUnloaded() {
        PipeNetwork.get(this.level).uncachePipe(this.worldPosition);
    }

    public void saveAdditional(CompoundTag compound) {
        super.saveAdditional(compound);
        compound.put("modules", (Tag)this.modules.serializeNBT());
        compound.putInt("module_drop_check", this.moduleDropCheck);
        compound.put("requests", (Tag)Utility.serializeAll(this.craftIngredientRequests));
        if (this.cover != null) {
            compound.put("cover", (Tag)NbtUtils.writeBlockState((BlockState)this.cover));
        }
        ListTag results = new ListTag();
        for (Pair<BlockPos, ItemStack> triple : this.craftResultRequests) {
            CompoundTag nbt = new CompoundTag();
            nbt.putLong("dest_pipe", ((BlockPos)triple.getLeft()).asLong());
            nbt.put("item", (Tag)((ItemStack)triple.getRight()).save(new CompoundTag()));
            results.add((Object)nbt);
        }
        compound.put("craft_results", (Tag)results);
    }

    public void load(CompoundTag compound) {
        this.modules.deserializeNBT(compound.getCompound("modules"));
        this.moduleDropCheck = compound.getInt("module_drop_check");
        this.cover = compound.contains("cover") ? NbtUtils.readBlockState((HolderGetter)(this.level != null ? this.level.holderLookup(Registries.BLOCK) : BuiltInRegistries.BLOCK.asLookup()), (CompoundTag)compound.getCompound("cover")) : null;
        this.craftIngredientRequests.clear();
        this.craftIngredientRequests.addAll(Utility.deserializeAll(compound.getList("requests", 10), NetworkLock::new));
        this.craftResultRequests.clear();
        ListTag results = compound.getList("craft_results", 10);
        for (int i = 0; i < results.size(); ++i) {
            CompoundTag nbt = results.getCompound(i);
            this.craftResultRequests.add((Pair<BlockPos, ItemStack>)Pair.of((Object)BlockPos.of((long)nbt.getLong("dest_pipe")), (Object)ItemStack.of((CompoundTag)nbt.getCompound("item"))));
        }
        super.load(compound);
    }

    public CompoundTag getUpdateTag() {
        CompoundTag nbt = this.saveWithoutMetadata();
        nbt.put("items", (Tag)Utility.serializeAll(this.getItems()));
        return nbt;
    }

    public void handleUpdateTag(CompoundTag nbt) {
        this.load(nbt);
        List<IPipeItem> items = this.getItems();
        items.clear();
        items.addAll(Utility.deserializeAll(nbt.getList("items", 10), IPipeItem::load));
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.load(pkt.getTag());
    }

    public List<IPipeItem> getItems() {
        if (this.items == null) {
            this.items = PipeNetwork.get(this.level).getItemsInPipe(this.worldPosition);
        }
        return this.items;
    }

    public void addNewItem(IPipeItem item) {
        if (!this.getItems().contains(item)) {
            this.getItems().add(item);
        }
        if (this.pressurizer != null) {
            this.pressurizer.pressurizeItem(item.getContent(), false);
        }
    }

    public boolean isConnected(Direction dir) {
        return ((ConnectionType)((Object)this.getBlockState().getValue((Property)PipeBlock.DIRECTIONS.get(dir)))).isConnected();
    }

    public Pair<BlockPos, ItemStack> getAvailableDestinationOrConnectable(ItemStack stack, boolean force, boolean preventOversending) {
        Pair<BlockPos, ItemStack> dest = this.getAvailableDestination(Direction.values(), stack, force, preventOversending);
        if (dest != null) {
            return dest;
        }
        for (Direction dir : Direction.values()) {
            ItemStack connectableRemain;
            IPipeConnectable connectable = this.getPipeConnectable(dir);
            if (connectable == null || (connectableRemain = connectable.insertItem(this.worldPosition, dir, stack, true)).getCount() == stack.getCount()) continue;
            ItemStack inserted = stack.copy();
            inserted.shrink(connectableRemain.getCount());
            return Pair.of((Object)this.worldPosition.relative(dir), (Object)inserted);
        }
        return null;
    }

    public Pair<BlockPos, ItemStack> getAvailableDestination(Direction[] directions, ItemStack stack, boolean force, boolean preventOversending) {
        if (!this.canWork()) {
            return null;
        }
        for (Direction dir : directions) {
            PipeNetwork network;
            int onTheWay;
            IItemHandler handler = this.getItemHandler(dir);
            if (handler == null || !force && this.streamModules().anyMatch(m -> !((IModule)m.getRight()).canAcceptItem((ItemStack)m.getLeft(), this, stack, dir, handler))) continue;
            int startSlot = 0;
            int slotAmount = handler.getSlots();
            if (handler.getClass().getName().equals("com.jaquadro.minecraft.storagedrawers.capabilities.DrawerItemHandler")) {
                slotAmount = 1;
            }
            ItemStack remain = stack;
            for (int i = startSlot; i < slotAmount && !(remain = handler.insertItem(i, remain, true)).isEmpty(); ++i) {
            }
            if (remain.getCount() == stack.getCount()) continue;
            ItemStack toInsert = stack.copy();
            toInsert.shrink(remain.getCount());
            int maxAmount = this.streamModules().mapToInt(m -> ((IModule)m.getRight()).getMaxInsertionAmount((ItemStack)m.getLeft(), this, stack, handler)).min().orElse(Integer.MAX_VALUE);
            if (maxAmount < toInsert.getCount()) {
                toInsert.setCount(maxAmount);
            }
            BlockPos offset = this.worldPosition.relative(dir);
            if ((preventOversending || maxAmount < Integer.MAX_VALUE) && (onTheWay = (network = PipeNetwork.get(this.level)).getItemsOnTheWay(offset, null, new ItemEquality[0])) > 0) {
                if (maxAmount < Integer.MAX_VALUE) {
                    int onTheWaySame = network.getItemsOnTheWay(offset, stack, new ItemEquality[0]);
                    if (toInsert.getCount() + onTheWaySame > maxAmount) {
                        toInsert.setCount(maxAmount - onTheWaySame);
                    }
                }
                int totalSpace = 0;
                ItemStack copy = stack.copy();
                for (int i = startSlot; i < slotAmount; ++i) {
                    int maxStackSize = copy.getMaxStackSize();
                    int limit = handler.getSlotLimit(i);
                    if (limit > 64) {
                        maxStackSize = limit;
                    }
                    copy.setCount(maxStackSize);
                    ItemStack left = handler.insertItem(i, copy, true);
                    totalSpace += maxStackSize - left.getCount();
                }
                if (onTheWay + toInsert.getCount() > totalSpace) {
                    toInsert.setCount(totalSpace - onTheWay);
                }
            }
            if (toInsert.isEmpty()) continue;
            return Pair.of((Object)offset, (Object)toInsert);
        }
        return null;
    }

    public int getPriority() {
        return this.priority;
    }

    public float getItemSpeed(ItemStack stack) {
        float moduleSpeed = (float)this.streamModules().mapToDouble(m -> ((IModule)m.getRight()).getItemSpeedIncrease((ItemStack)m.getLeft(), this)).sum();
        float pressureSpeed = this.pressurizer != null && this.pressurizer.pressurizeItem(stack, true) ? 0.45f : 0.0f;
        return 0.05f + moduleSpeed + pressureSpeed;
    }

    public boolean canWork() {
        return this.streamModules().allMatch(m -> ((IModule)m.getRight()).canPipeWork((ItemStack)m.getLeft(), this));
    }

    public List<ItemStack> getAllCraftables() {
        return this.streamModules().flatMap(m -> ((IModule)m.getRight()).getAllCraftables((ItemStack)m.getLeft(), this).stream()).collect(Collectors.toList());
    }

    public int getCraftableAmount(Consumer<ItemStack> unavailableConsumer, ItemStack stack, Stack<ItemStack> dependencyChain) {
        int total = 0;
        Iterator modules = this.streamModules().iterator();
        while (modules.hasNext()) {
            int amount;
            Pair module = (Pair)modules.next();
            if (dependencyChain.contains(module.getLeft()) || (amount = ((IModule)module.getRight()).getCraftableAmount((ItemStack)module.getLeft(), this, unavailableConsumer, stack, dependencyChain)) <= 0) continue;
            total += amount;
        }
        return total;
    }

    public ItemStack craft(BlockPos destPipe, Consumer<ItemStack> unavailableConsumer, ItemStack stack, Stack<ItemStack> dependencyChain) {
        Pair module;
        Iterator modules = this.streamModules().iterator();
        while (modules.hasNext() && !(stack = ((IModule)(module = (Pair)modules.next()).getRight()).craft((ItemStack)module.getLeft(), this, destPipe, unavailableConsumer, stack, dependencyChain)).isEmpty()) {
        }
        return stack;
    }

    public IItemHandler getItemHandler(Direction dir) {
        IItemHandler handler = (IItemHandler)this.getNeighborCap(dir, Capabilities.ItemHandler.BLOCK);
        if (handler != null) {
            return handler;
        }
        return Utility.getBlockItemHandler(this.level, this.worldPosition.relative(dir), dir.getOpposite());
    }

    public <T, C> T getNeighborCap(Direction dir, BlockCapability<T, Direction> cap) {
        if (!this.isConnected(dir)) {
            return null;
        }
        BlockPos pos = this.worldPosition.relative(dir);
        BlockEntity tile = this.level.getBlockEntity(pos);
        if (tile != null) {
            return (T)this.level.getCapability(cap, tile.getBlockPos(), tile.getBlockState(), tile, (Object)dir.getOpposite());
        }
        return null;
    }

    public IPipeConnectable getPipeConnectable(Direction dir) {
        BlockEntity tile = this.level.getBlockEntity(this.worldPosition.relative(dir));
        if (tile != null) {
            return (IPipeConnectable)this.level.getCapability(Registry.pipeConnectableCapability, tile.getBlockPos(), tile.getBlockState(), tile, (Object)dir.getOpposite());
        }
        return null;
    }

    public boolean canHaveModules() {
        for (Direction dir : Direction.values()) {
            if (this.getItemHandler(dir) != null) {
                return true;
            }
            IPipeConnectable connectable = this.getPipeConnectable(dir);
            if (connectable == null || !connectable.allowsModules(this.worldPosition, dir)) continue;
            return true;
        }
        return false;
    }

    public boolean canNetworkSee(Direction direction, IItemHandler handler) {
        return this.streamModules().allMatch(m -> ((IModule)m.getRight()).canNetworkSee((ItemStack)m.getLeft(), this, direction, handler));
    }

    public Stream<Pair<ItemStack, IModule>> streamModules() {
        Stream.Builder<Pair> builder = Stream.builder();
        for (int i = 0; i < this.modules.getSlots(); ++i) {
            Item item;
            ItemStack stack = this.modules.getStackInSlot(i);
            if (stack.isEmpty() || !((item = stack.getItem()) instanceof IModule)) continue;
            IModule module = (IModule)item;
            builder.accept(Pair.of((Object)stack, (Object)module));
        }
        return builder.build();
    }

    public void removeCover(Player player, InteractionHand hand) {
        if (this.level.isClientSide) {
            return;
        }
        List drops = Block.getDrops((BlockState)this.cover, (ServerLevel)((ServerLevel)this.level), (BlockPos)this.worldPosition, null, (Entity)player, (ItemStack)player.getItemInHand(hand));
        for (ItemStack drop : drops) {
            Containers.dropItemStack((Level)this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (ItemStack)drop);
        }
        this.cover = null;
    }

    public boolean shouldWorkNow(int speed) {
        return (this.level.getGameTime() + (long)((Integer)this.workRandomizer.get()).intValue()) % (long)speed == 0L;
    }

    public int getNextNode(List<BlockPos> nodes, int index) {
        return this.streamModules().map(m -> ((IModule)m.getRight()).getCustomNextNode((ItemStack)m.getLeft(), this, nodes, index)).filter(m -> m != null && m >= 0).findFirst().orElse(index);
    }

    public List<ItemFilter> getFilters(Direction direction) {
        return this.streamModules().map(p -> {
            DirectionSelector dir;
            if (direction != null && (dir = ((IModule)p.getRight()).getDirectionSelector((ItemStack)p.getLeft(), this)) != null && !dir.has(direction)) {
                return null;
            }
            return ((IModule)p.getRight()).getItemFilter((ItemStack)p.getLeft(), this);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.prettypipes.pipe");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int window, Inventory inv, Player player) {
        return new MainPipeContainer(Registry.pipeContainer, window, player, this.worldPosition);
    }

    @Override
    public ConnectionType getConnectionType(BlockPos pipePos, Direction direction) {
        BlockState state = this.level.getBlockState(pipePos.relative(direction));
        if (state.getValue((Property)PipeBlock.DIRECTIONS.get(direction.getOpposite())) == ConnectionType.BLOCKED) {
            return ConnectionType.BLOCKED;
        }
        return ConnectionType.CONNECTED;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PipeBlockEntity pipe) {
        if (pipe.pressurizer != null && pipe.pressurizer.isRemoved()) {
            pipe.pressurizer = null;
        }
        if (!pipe.level.isAreaLoaded(pipe.worldPosition, 1)) {
            return;
        }
        ProfilerFiller profiler = pipe.level.getProfiler();
        if (!pipe.level.isClientSide) {
            if (pipe.moduleDropCheck > 0) {
                --pipe.moduleDropCheck;
                if (pipe.moduleDropCheck <= 0 && !pipe.canHaveModules()) {
                    Utility.dropInventory(pipe, (IItemHandler)pipe.modules);
                }
            }
            profiler.push("ticking_modules");
            int prio = 0;
            Iterator modules = pipe.streamModules().iterator();
            while (modules.hasNext()) {
                Pair module = (Pair)modules.next();
                ((IModule)module.getRight()).tick((ItemStack)module.getLeft(), pipe);
                prio += ((IModule)module.getRight()).getPriority((ItemStack)module.getLeft(), pipe);
            }
            if (prio != pipe.priority) {
                pipe.priority = prio;
                PipeNetwork.get(pipe.level).clearDestinationCache(Collections.singletonList(pipe.worldPosition));
            }
            profiler.pop();
        }
        profiler.push("ticking_items");
        List<IPipeItem> items = pipe.getItems();
        for (int i = items.size() - 1; i >= 0; --i) {
            items.get(i).updateInPipe(pipe);
        }
        if (items.size() != pipe.lastItemAmount) {
            pipe.lastItemAmount = items.size();
            pipe.level.updateNeighbourForOutputSignal(pipe.worldPosition, pipe.getBlockState().getBlock());
        }
        profiler.pop();
    }
}

