/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.pipe.modules.craft;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.items.ModuleItem;
import de.ellpeck.prettypipes.items.ModuleTier;
import de.ellpeck.prettypipes.misc.ItemEquality;
import de.ellpeck.prettypipes.misc.ItemFilter;
import de.ellpeck.prettypipes.network.NetworkLocation;
import de.ellpeck.prettypipes.network.NetworkLock;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import de.ellpeck.prettypipes.pipe.containers.AbstractPipeContainer;
import de.ellpeck.prettypipes.pipe.modules.craft.CraftingModuleContainer;
import de.ellpeck.prettypipes.terminal.CraftingTerminalBlockEntity;
import de.ellpeck.prettypipes.terminal.ItemTerminalBlockEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class CraftingModuleItem
extends ModuleItem {
    public final int inputSlots;
    public final int outputSlots;
    private final int speed;

    public CraftingModuleItem(String name, ModuleTier tier) {
        super(name);
        this.inputSlots = tier.forTier(1, 4, 9);
        this.outputSlots = tier.forTier(1, 2, 4);
        this.speed = tier.forTier(20, 10, 5);
    }

    @Override
    public boolean isCompatible(ItemStack module, PipeBlockEntity tile, IModule other) {
        return true;
    }

    @Override
    public boolean hasContainer(ItemStack module, PipeBlockEntity tile) {
        return true;
    }

    @Override
    public AbstractPipeContainer<?> getContainer(ItemStack module, PipeBlockEntity tile, int windowId, Inventory inv, Player player, int moduleIndex) {
        return new CraftingModuleContainer(Registry.craftingModuleContainer, windowId, player, tile.getBlockPos(), moduleIndex);
    }

    @Override
    public boolean canNetworkSee(ItemStack module, PipeBlockEntity tile, Direction direction, IItemHandler handler) {
        return false;
    }

    @Override
    public boolean canAcceptItem(ItemStack module, PipeBlockEntity tile, ItemStack stack, Direction direction, IItemHandler destination) {
        return false;
    }

    @Override
    public void tick(ItemStack module, PipeBlockEntity tile) {
        ItemStack remain;
        ItemEquality[] equalityTypes;
        if (!tile.shouldWorkNow(this.speed) || !tile.canWork()) {
            return;
        }
        PipeNetwork network = PipeNetwork.get(tile.getLevel());
        if (!tile.craftIngredientRequests.isEmpty()) {
            network.startProfile("crafting_ingredients");
            NetworkLock request = tile.craftIngredientRequests.peek();
            equalityTypes = ItemFilter.getEqualityTypes(tile);
            Pair<BlockPos, ItemStack> dest = tile.getAvailableDestination(Direction.values(), request.stack, true, true);
            if (dest != null) {
                ItemStack requestRemain = network.requestExistingItem(request.location, tile.getBlockPos(), (BlockPos)dest.getLeft(), request, (ItemStack)dest.getRight(), equalityTypes);
                network.resolveNetworkLock(request);
                tile.craftIngredientRequests.remove();
                remain = request.stack.copy();
                remain.shrink(((ItemStack)dest.getRight()).getCount() - requestRemain.getCount());
                if (!remain.isEmpty()) {
                    NetworkLock remainRequest = new NetworkLock(request.location, remain);
                    tile.craftIngredientRequests.add(remainRequest);
                    network.createNetworkLock(remainRequest);
                }
            }
            network.endProfile();
        }
        if (!tile.craftResultRequests.isEmpty()) {
            network.startProfile("crafting_results");
            List<NetworkLocation> items = network.getOrderedNetworkItems(tile.getBlockPos());
            equalityTypes = ItemFilter.getEqualityTypes(tile);
            for (Pair<BlockPos, ItemStack> request : tile.craftResultRequests) {
                Pair<BlockPos, ItemStack> dest;
                remain = ((ItemStack)request.getRight()).copy();
                PipeBlockEntity destPipe = network.getPipe((BlockPos)request.getLeft());
                if (destPipe == null || (dest = destPipe.getAvailableDestinationOrConnectable(remain, true, true)) == null) continue;
                for (NetworkLocation item : items) {
                    ItemStack requestRemain = network.requestExistingItem(item, (BlockPos)request.getLeft(), (BlockPos)dest.getLeft(), null, (ItemStack)dest.getRight(), equalityTypes);
                    remain.shrink(((ItemStack)dest.getRight()).getCount() - requestRemain.getCount());
                    if (!remain.isEmpty()) continue;
                    break;
                }
                if (remain.getCount() == ((ItemStack)request.getRight()).getCount()) continue;
                tile.craftResultRequests.remove(request);
                if (!remain.isEmpty()) {
                    tile.craftResultRequests.add((Pair<BlockPos, ItemStack>)Pair.of((Object)((BlockPos)request.getLeft()), (Object)remain));
                }
                network.endProfile();
                return;
            }
            network.endProfile();
        }
    }

    @Override
    public List<ItemStack> getAllCraftables(ItemStack module, PipeBlockEntity tile) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ItemStackHandler output = this.getOutput(module);
        for (int i = 0; i < output.getSlots(); ++i) {
            ItemStack stack = output.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            ret.add(stack);
        }
        return ret;
    }

    @Override
    public int getCraftableAmount(ItemStack module, PipeBlockEntity tile, Consumer<ItemStack> unavailableConsumer, ItemStack stack, Stack<ItemStack> dependencyChain) {
        PipeNetwork network = PipeNetwork.get(tile.getLevel());
        List<NetworkLocation> items = network.getOrderedNetworkItems(tile.getBlockPos());
        ItemEquality[] equalityTypes = ItemFilter.getEqualityTypes(tile);
        ItemStackHandler input = this.getInput(module);
        int craftable = 0;
        ItemStackHandler output = this.getOutput(module);
        for (int i = 0; i < output.getSlots(); ++i) {
            ItemStack out = output.getStackInSlot(i);
            if (out.isEmpty() || !ItemEquality.compareItems(out, stack, equalityTypes)) continue;
            int availableCrafts = CraftingTerminalBlockEntity.getAvailableCrafts(tile, input.getSlots(), arg_0 -> ((ItemStackHandler)input).getStackInSlot(arg_0), k -> true, s -> items, unavailableConsumer, CraftingModuleItem.addDependency(dependencyChain, module), equalityTypes);
            if (availableCrafts <= 0) continue;
            craftable += out.getCount() * availableCrafts;
        }
        return craftable;
    }

    @Override
    public ItemStack craft(ItemStack module, PipeBlockEntity tile, BlockPos destPipe, Consumer<ItemStack> unavailableConsumer, ItemStack stack, Stack<ItemStack> dependencyChain) {
        int craftableAmount = this.getCraftableAmount(module, tile, unavailableConsumer, stack, dependencyChain);
        if (craftableAmount <= 0) {
            return stack;
        }
        PipeNetwork network = PipeNetwork.get(tile.getLevel());
        List<NetworkLocation> items = network.getOrderedNetworkItems(tile.getBlockPos());
        ItemEquality[] equalityTypes = ItemFilter.getEqualityTypes(tile);
        int resultAmount = this.getResultAmountPerCraft(module, stack, equalityTypes);
        int requiredCrafts = Mth.ceil((float)((float)stack.getCount() / (float)resultAmount));
        int craftableCrafts = Mth.ceil((float)((float)craftableAmount / (float)resultAmount));
        int toCraft = Math.min(craftableCrafts, requiredCrafts);
        ItemStackHandler input = this.getInput(module);
        for (int i = 0; i < input.getSlots(); ++i) {
            ItemStack in = input.getStackInSlot(i);
            if (in.isEmpty()) continue;
            ItemStack copy = in.copy();
            copy.setCount(in.getCount() * toCraft);
            Pair<List<NetworkLock>, ItemStack> ret = ItemTerminalBlockEntity.requestItemLater(tile.getLevel(), tile.getBlockPos(), items, unavailableConsumer, copy, CraftingModuleItem.addDependency(dependencyChain, module), equalityTypes);
            tile.craftIngredientRequests.addAll((Collection)ret.getLeft());
        }
        ItemStack remain = stack.copy();
        remain.shrink(resultAmount * toCraft);
        ItemStack result = stack.copy();
        result.shrink(remain.getCount());
        tile.craftResultRequests.add((Pair<BlockPos, ItemStack>)Pair.of((Object)destPipe, (Object)result));
        return remain;
    }

    public ItemStackHandler getInput(ItemStack module) {
        ItemStackHandler handler = new ItemStackHandler(this.inputSlots);
        if (module.hasTag()) {
            handler.deserializeNBT(module.getTag().getCompound("input"));
        }
        return handler;
    }

    public ItemStackHandler getOutput(ItemStack module) {
        ItemStackHandler handler = new ItemStackHandler(this.outputSlots);
        if (module.hasTag()) {
            handler.deserializeNBT(module.getTag().getCompound("output"));
        }
        return handler;
    }

    public void save(ItemStackHandler input, ItemStackHandler output, ItemStack module) {
        CompoundTag tag = module.getOrCreateTag();
        if (input != null) {
            tag.put("input", (Tag)input.serializeNBT());
        }
        if (output != null) {
            tag.put("output", (Tag)output.serializeNBT());
        }
    }

    private int getResultAmountPerCraft(ItemStack module, ItemStack stack, ItemEquality ... equalityTypes) {
        ItemStackHandler output = this.getOutput(module);
        int resultAmount = 0;
        for (int i = 0; i < output.getSlots(); ++i) {
            ItemStack out = output.getStackInSlot(i);
            if (!ItemEquality.compareItems(stack, out, equalityTypes)) continue;
            resultAmount += out.getCount();
        }
        return resultAmount;
    }

    private static Stack<ItemStack> addDependency(Stack<ItemStack> deps, ItemStack module) {
        deps = (Stack)deps.clone();
        deps.push(module);
        return deps;
    }
}

