/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.pipe.modules.stacksize;

import de.ellpeck.prettypipes.packets.PacketButton;
import de.ellpeck.prettypipes.pipe.containers.AbstractPipeGui;
import de.ellpeck.prettypipes.pipe.modules.stacksize.StackSizeModuleContainer;
import de.ellpeck.prettypipes.pipe.modules.stacksize.StackSizeModuleItem;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class StackSizeModuleGui
extends AbstractPipeGui<StackSizeModuleContainer> {
    public StackSizeModuleGui(StackSizeModuleContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
    }

    @Override
    protected void init() {
        super.init();
        1 textField = this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.leftPos + 7, this.topPos + 17 + 32 + 10, 40, 20, (Component)Component.translatable((String)"info.prettypipes.max_stack_size")){

            public void insertText(String textToWrite) {
                StringBuilder ret = new StringBuilder();
                for (char c : textToWrite.toCharArray()) {
                    if (!Character.isDigit(c)) continue;
                    ret.append(c);
                }
                super.insertText(ret.toString());
            }
        });
        textField.setValue(String.valueOf(StackSizeModuleItem.getMaxStackSizeForModule(((StackSizeModuleContainer)this.menu).moduleStack)));
        textField.setMaxLength(4);
        textField.setResponder(s -> {
            if (s.isEmpty()) {
                return;
            }
            int amount = Integer.parseInt(s);
            PacketButton.sendAndExecute(((StackSizeModuleContainer)this.menu).tile.getBlockPos(), PacketButton.ButtonResult.STACK_SIZE_AMOUNT, amount);
        });
        Supplier<Component> buttonText = () -> Component.translatable((String)("info.prettypipes.limit_to_max_" + (StackSizeModuleItem.getLimitToMaxStackSize(((StackSizeModuleContainer)this.menu).moduleStack) ? "on" : "off")));
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)buttonText.get(), b -> {
            PacketButton.sendAndExecute(((StackSizeModuleContainer)this.menu).tile.getBlockPos(), PacketButton.ButtonResult.STACK_SIZE_MODULE_BUTTON, new int[0]);
            b.setMessage((Component)buttonText.get());
        }).bounds(this.leftPos + 7, this.topPos + 17 + 32 + 10 + 22, 120, 20).build());
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderLabels(graphics, mouseX, mouseY);
        graphics.drawString(this.font, I18n.get((String)"info.prettypipes.max_stack_size", (Object[])new Object[0]) + ":", 7, 49, 0x404040, false);
    }
}

