/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.terminal;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.misc.EquatableItemStack;
import de.ellpeck.prettypipes.misc.ItemEquality;
import de.ellpeck.prettypipes.network.NetworkItem;
import de.ellpeck.prettypipes.network.NetworkLocation;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.packets.PacketGhostSlot;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import de.ellpeck.prettypipes.terminal.ItemTerminalBlockEntity;
import de.ellpeck.prettypipes.terminal.containers.CraftingTerminalContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.mutable.MutableInt;

public class CraftingTerminalBlockEntity
extends ItemTerminalBlockEntity {
    public final ItemStackHandler craftItems = new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            for (Player playerEntity : CraftingTerminalBlockEntity.this.getLookingPlayers()) {
                playerEntity.containerMenu.slotsChanged(null);
            }
        }
    };
    public final ItemStackHandler ghostItems = new ItemStackHandler(9);

    public CraftingTerminalBlockEntity(BlockPos pos, BlockState state) {
        super(Registry.craftingTerminalBlockEntity, pos, state);
    }

    public ItemStack getRequestedCraftItem(int slot) {
        ItemStack stack = this.craftItems.getStackInSlot(slot);
        if (!stack.isEmpty()) {
            return stack;
        }
        return this.ghostItems.getStackInSlot(slot);
    }

    public boolean isGhostItem(int slot) {
        return this.craftItems.getStackInSlot(slot).isEmpty() && !this.ghostItems.getStackInSlot(slot).isEmpty();
    }

    public void setGhostItems(List<PacketGhostSlot.Entry> stacks) {
        this.updateItems(new Player[0]);
        for (int i = 0; i < this.ghostItems.getSlots(); ++i) {
            List<ItemStack> items = stacks.get(i).getStacks(this.level);
            if (items.isEmpty()) {
                this.ghostItems.setStackInSlot(i, ItemStack.EMPTY);
                continue;
            }
            ItemStack toSet = items.get(0);
            if (items.size() > 1) {
                int highestAmount = 0;
                for (ItemStack stack : items) {
                    PipeBlockEntity pipe;
                    int amount = 0;
                    NetworkItem network = (NetworkItem)this.networkItems.get(new EquatableItemStack(stack, ItemEquality.NBT));
                    if (network != null) {
                        amount = network.getLocations().stream().mapToInt(l -> l.getItemAmount(this.level, stack, ItemEquality.NBT)).sum();
                    }
                    if (amount <= 0 && highestAmount <= 0 && (pipe = this.getConnectedPipe()) != null) {
                        amount = PipeNetwork.get(this.level).getCraftableAmount(pipe.getBlockPos(), null, stack, new Stack<ItemStack>(), ItemEquality.NBT);
                    }
                    if (amount <= highestAmount) continue;
                    highestAmount = amount;
                    toSet = stack;
                }
            }
            this.ghostItems.setStackInSlot(i, toSet.copy());
        }
        if (!this.level.isClientSide) {
            ArrayList<PacketGhostSlot.Entry> clients = new ArrayList<PacketGhostSlot.Entry>();
            for (int i = 0; i < this.ghostItems.getSlots(); ++i) {
                clients.add(new PacketGhostSlot.Entry(this.level, Collections.singletonList(this.ghostItems.getStackInSlot(i))));
            }
            PacketDistributor.TRACKING_CHUNK.with((Object)this.level.getChunkAt(this.getBlockPos())).send(new CustomPacketPayload[]{new PacketGhostSlot(this.getBlockPos(), clients)});
        }
    }

    public void requestCraftingItems(Player player, int maxAmount, boolean force) {
        PipeBlockEntity pipe = this.getConnectedPipe();
        if (pipe == null) {
            return;
        }
        PipeNetwork network = PipeNetwork.get(this.level);
        network.startProfile("terminal_request_crafting");
        this.updateItems(new Player[0]);
        int lowestAvailable = CraftingTerminalBlockEntity.getAvailableCrafts(pipe, this.craftItems.getSlots(), i -> ItemHandlerHelper.copyStackWithSize((ItemStack)this.getRequestedCraftItem((int)i), (int)1), this::isGhostItem, s -> {
            NetworkItem item = (NetworkItem)this.networkItems.get(s);
            return item != null ? item.getLocations() : Collections.emptyList();
        }, ItemTerminalBlockEntity.onItemUnavailable(player, force), new Stack<ItemStack>(), ItemEquality.NBT);
        if (lowestAvailable <= 0 && force) {
            lowestAvailable = maxAmount;
        }
        if (lowestAvailable > 0) {
            if (maxAmount < lowestAvailable) {
                lowestAvailable = maxAmount;
            }
            for (int i2 = 0; i2 < this.craftItems.getSlots(); ++i2) {
                ItemStack requested = this.getRequestedCraftItem(i2);
                if (requested.isEmpty()) continue;
                requested = requested.copy();
                requested.setCount(lowestAvailable);
                this.requestItemImpl(requested, ItemTerminalBlockEntity.onItemUnavailable(player, force));
            }
            player.sendSystemMessage((Component)Component.translatable((String)"info.prettypipes.sending_ingredients", (Object[])new Object[]{lowestAvailable}).setStyle(Style.EMPTY.applyFormat(ChatFormatting.GREEN)));
        } else {
            player.sendSystemMessage((Component)Component.translatable((String)"info.prettypipes.hold_alt"));
        }
        network.endProfile();
    }

    @Override
    public void saveAdditional(CompoundTag compound) {
        super.saveAdditional(compound);
        compound.put("craft_items", (Tag)this.craftItems.serializeNBT());
    }

    @Override
    public void load(CompoundTag compound) {
        this.craftItems.deserializeNBT(compound.getCompound("craft_items"));
        super.load(compound);
    }

    @Override
    public Component getDisplayName() {
        return Component.translatable((String)"container.prettypipes.crafting_terminal");
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int window, Inventory inv, Player player) {
        return new CraftingTerminalContainer(Registry.craftingTerminalContainer, window, player, this.worldPosition);
    }

    @Override
    public ItemStack insertItem(BlockPos pipePos, Direction direction, ItemStack remain, boolean simulate) {
        BlockPos pos = pipePos.relative(direction);
        CraftingTerminalBlockEntity tile = Utility.getBlockEntity(CraftingTerminalBlockEntity.class, (BlockGetter)this.level, pos);
        if (tile != null) {
            remain = remain.copy();
            int lowestSlot = -1;
            do {
                for (int i = 0; i < tile.craftItems.getSlots(); ++i) {
                    int count;
                    ItemStack stack = tile.getRequestedCraftItem(i);
                    int n = count = tile.isGhostItem(i) ? 0 : stack.getCount();
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)remain) || !stack.isStackable() && count >= 1 || lowestSlot >= 0 && (tile.isGhostItem(lowestSlot) || count >= tile.getRequestedCraftItem(lowestSlot).getCount())) continue;
                    lowestSlot = i;
                }
                if (lowestSlot < 0) continue;
                ItemStack copy = remain.copy();
                copy.setCount(1);
                if (tile.craftItems.insertItem(lowestSlot, copy, simulate).getCount() > 0) break;
                remain.shrink(1);
                if (!remain.isEmpty()) continue;
                return ItemStack.EMPTY;
            } while (lowestSlot >= 0);
            return ItemHandlerHelper.insertItemStacked((IItemHandler)tile.items, (ItemStack)remain, (boolean)simulate);
        }
        return remain;
    }

    public static int getAvailableCrafts(PipeBlockEntity tile, int slots, Function<Integer, ItemStack> inputFunction, Predicate<Integer> isGhost, Function<EquatableItemStack, Collection<NetworkLocation>> locationsFunction, Consumer<ItemStack> unavailableConsumer, Stack<ItemStack> dependencyChain, ItemEquality ... equalityTypes) {
        PipeNetwork network = PipeNetwork.get(tile.getLevel());
        int lowestAvailable = Integer.MAX_VALUE;
        HashMap<EquatableItemStack, MutableInt> requiredItems = new HashMap<EquatableItemStack, MutableInt>();
        for (int i = 0; i < slots; ++i) {
            ItemStack requested = inputFunction.apply(i);
            if (requested.isEmpty()) continue;
            MutableInt amount = requiredItems.computeIfAbsent(new EquatableItemStack(requested, equalityTypes), s -> new MutableInt());
            amount.add(requested.getCount());
            int fit = Math.max(requested.getMaxStackSize() - (isGhost.test(i) ? 0 : requested.getCount()), 1);
            if (lowestAvailable <= fit) continue;
            lowestAvailable = fit;
        }
        for (Map.Entry entry : requiredItems.entrySet()) {
            int craftable;
            EquatableItemStack stack = (EquatableItemStack)entry.getKey();
            int available = 0;
            for (NetworkLocation location : locationsFunction.apply(stack)) {
                int amount = location.getItemAmount(tile.getLevel(), stack.stack(), equalityTypes);
                if (amount <= 0) continue;
                available += (amount -= network.getLockedAmount(location.getPos(), stack.stack(), null, equalityTypes));
            }
            if ((available /= ((MutableInt)entry.getValue()).intValue()) < lowestAvailable && (craftable = network.getCraftableAmount(tile.getBlockPos(), unavailableConsumer, stack.stack(), dependencyChain, equalityTypes)) > 0) {
                available += craftable / ((MutableInt)entry.getValue()).intValue();
            }
            if (available < lowestAvailable) {
                lowestAvailable = available;
            }
            if (available > 0 || unavailableConsumer == null) continue;
            unavailableConsumer.accept(stack.stack());
        }
        return lowestAvailable;
    }
}

