/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.terminal;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.misc.EquatableItemStack;
import de.ellpeck.prettypipes.misc.ItemEquality;
import de.ellpeck.prettypipes.network.NetworkItem;
import de.ellpeck.prettypipes.network.NetworkLocation;
import de.ellpeck.prettypipes.network.NetworkLock;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.packets.PacketNetworkItems;
import de.ellpeck.prettypipes.pipe.ConnectionType;
import de.ellpeck.prettypipes.pipe.IPipeConnectable;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import de.ellpeck.prettypipes.terminal.containers.ItemTerminalContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class ItemTerminalBlockEntity
extends BlockEntity
implements IPipeConnectable,
MenuProvider {
    public final ItemStackHandler items = new ItemStackHandler(12){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }
    };
    protected Map<EquatableItemStack, NetworkItem> networkItems;
    private final Queue<NetworkLock> existingRequests = new LinkedList<NetworkLock>();

    public ItemTerminalBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ItemTerminalBlockEntity(BlockPos pos, BlockState state) {
        this(Registry.itemTerminalBlockEntity, pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ItemTerminalBlockEntity terminal) {
        Player[] lookingPlayers;
        int interval;
        if (terminal.level.isClientSide) {
            return;
        }
        PipeNetwork network = PipeNetwork.get(terminal.level);
        PipeBlockEntity pipe = terminal.getConnectedPipe();
        if (pipe == null) {
            return;
        }
        boolean update = false;
        int n = interval = pipe.pressurizer != null ? 2 : 10;
        if (terminal.level.getGameTime() % (long)interval == 0L) {
            for (int i = 6; i < 12; ++i) {
                ItemStack remain;
                ItemStack extracted = terminal.items.extractItem(i, Integer.MAX_VALUE, true);
                if (extracted.isEmpty() || (remain = network.routeItem(pipe.getBlockPos(), terminal.getBlockPos(), extracted, true)).getCount() == extracted.getCount()) continue;
                terminal.items.extractItem(i, extracted.getCount() - remain.getCount(), false);
                break;
            }
            if (!terminal.existingRequests.isEmpty()) {
                NetworkLock request = terminal.existingRequests.remove();
                network.resolveNetworkLock(request);
                network.requestExistingItem(request.location, pipe.getBlockPos(), terminal.getBlockPos(), request, request.stack, ItemEquality.NBT);
                update = true;
            }
        }
        if ((terminal.level.getGameTime() % 100L == 0L || update) && (lookingPlayers = terminal.getLookingPlayers()).length > 0) {
            terminal.updateItems(lookingPlayers);
        }
    }

    public void setRemoved() {
        super.setRemoved();
        PipeNetwork network = PipeNetwork.get(this.level);
        for (NetworkLock lock : this.existingRequests) {
            network.resolveNetworkLock(lock);
        }
    }

    public String getInvalidTerminalReason() {
        PipeNetwork network = PipeNetwork.get(this.level);
        long pipes = Arrays.stream(Direction.values()).map(d -> network.getPipe(this.worldPosition.relative(d))).filter(Objects::nonNull).count();
        if (pipes <= 0L) {
            return "info.prettypipes.no_pipe_connected";
        }
        if (pipes > 1L) {
            return "info.prettypipes.too_many_pipes_connected";
        }
        return null;
    }

    public PipeBlockEntity getConnectedPipe() {
        PipeNetwork network = PipeNetwork.get(this.level);
        for (Direction dir : Direction.values()) {
            PipeBlockEntity pipe = network.getPipe(this.worldPosition.relative(dir));
            if (pipe == null) continue;
            return pipe;
        }
        return null;
    }

    public void updateItems(Player ... playersToSync) {
        PipeBlockEntity pipe = this.getConnectedPipe();
        if (pipe == null) {
            return;
        }
        this.networkItems = this.collectItems(ItemEquality.NBT);
        if (playersToSync.length > 0) {
            List<ItemStack> clientItems = this.networkItems.values().stream().map(NetworkItem::asStack).collect(Collectors.toList());
            List<ItemStack> clientCraftables = PipeNetwork.get(this.level).getAllCraftables(pipe.getBlockPos()).stream().map(Pair::getRight).collect(Collectors.toList());
            List<ItemStack> currentlyCrafting = this.getCurrentlyCrafting().stream().sorted(Comparator.comparingInt(ItemStack::getCount).reversed()).collect(Collectors.toList());
            for (Player player : playersToSync) {
                AbstractContainerMenu abstractContainerMenu = player.containerMenu;
                if (!(abstractContainerMenu instanceof ItemTerminalContainer)) continue;
                ItemTerminalContainer container = (ItemTerminalContainer)abstractContainerMenu;
                if (container.tile != this) continue;
                ((ServerPlayer)player).connection.send((CustomPacketPayload)new PacketNetworkItems(clientItems, clientCraftables, currentlyCrafting));
            }
        }
    }

    public void requestItem(Player player, ItemStack stack, int nbtHash) {
        int requested;
        PipeNetwork network = PipeNetwork.get(this.level);
        network.startProfile("terminal_request_item");
        this.updateItems(new Player[0]);
        if (nbtHash != 0) {
            ItemStack filter = stack;
            stack = this.networkItems.values().stream().map(NetworkItem::asStack).filter(s -> ItemEquality.compareItems(s, filter, new ItemEquality[0]) && s.hasTag() && s.getTag().hashCode() == nbtHash).findFirst().orElse(filter);
            stack.setCount(filter.getCount());
        }
        if ((requested = this.requestItemImpl(stack, ItemTerminalBlockEntity.onItemUnavailable(player, false))) > 0) {
            player.sendSystemMessage((Component)Component.translatable((String)"info.prettypipes.sending", (Object[])new Object[]{requested, stack.getHoverName()}).setStyle(Style.EMPTY.applyFormat(ChatFormatting.GREEN)));
        } else {
            ItemTerminalBlockEntity.onItemUnavailable(player, false).accept(stack);
        }
        network.endProfile();
    }

    public int requestItemImpl(ItemStack stack, Consumer<ItemStack> unavailableConsumer) {
        NetworkItem item = this.networkItems.get(new EquatableItemStack(stack, ItemEquality.NBT));
        List<NetworkLocation> locations = item == null ? Collections.emptyList() : item.getLocations();
        Pair<List<NetworkLock>, ItemStack> ret = ItemTerminalBlockEntity.requestItemLater(this.level, this.getConnectedPipe().getBlockPos(), locations, unavailableConsumer, stack, new Stack<ItemStack>(), ItemEquality.NBT);
        this.existingRequests.addAll((Collection)ret.getLeft());
        return stack.getCount() - ((ItemStack)ret.getRight()).getCount();
    }

    public Player[] getLookingPlayers() {
        return (Player[])this.level.players().stream().filter(p -> {
            AbstractContainerMenu patt8396$temp = p.containerMenu;
            if (!(patt8396$temp instanceof ItemTerminalContainer)) return false;
            ItemTerminalContainer container = (ItemTerminalContainer)patt8396$temp;
            if (container.tile != this) return false;
            return true;
        }).toArray(Player[]::new);
    }

    private Map<EquatableItemStack, NetworkItem> collectItems(ItemEquality ... equalityTypes) {
        PipeNetwork network = PipeNetwork.get(this.level);
        network.startProfile("terminal_collect_items");
        PipeBlockEntity pipe = this.getConnectedPipe();
        HashMap<EquatableItemStack, NetworkItem> items = new HashMap<EquatableItemStack, NetworkItem>();
        for (NetworkLocation location : network.getOrderedNetworkItems(pipe.getBlockPos())) {
            for (Map.Entry<Integer, ItemStack> entry : location.getItems(this.level).entrySet()) {
                if (!location.canExtract(this.level, entry.getKey())) continue;
                EquatableItemStack equatable = new EquatableItemStack(entry.getValue(), equalityTypes);
                NetworkItem item = items.computeIfAbsent(equatable, NetworkItem::new);
                item.add(location, entry.getValue());
            }
        }
        network.endProfile();
        return items;
    }

    private List<ItemStack> getCurrentlyCrafting() {
        PipeNetwork network = PipeNetwork.get(this.level);
        PipeBlockEntity pipe = this.getConnectedPipe();
        if (pipe == null) {
            return Collections.emptyList();
        }
        List<Pair<BlockPos, ItemStack>> crafting = network.getCurrentlyCrafting(pipe.getBlockPos(), new ItemEquality[0]);
        return crafting.stream().map(Pair::getRight).collect(Collectors.toList());
    }

    public void cancelCrafting() {
        PipeNetwork network = PipeNetwork.get(this.level);
        PipeBlockEntity pipe = this.getConnectedPipe();
        if (pipe == null) {
            return;
        }
        for (Pair<BlockPos, ItemStack> craftable : network.getAllCraftables(pipe.getBlockPos())) {
            PipeBlockEntity otherPipe = network.getPipe((BlockPos)craftable.getLeft());
            if (otherPipe == null) continue;
            for (NetworkLock lock : otherPipe.craftIngredientRequests) {
                network.resolveNetworkLock(lock);
            }
            otherPipe.craftIngredientRequests.clear();
            otherPipe.craftResultRequests.clear();
        }
        Player[] lookingPlayers = this.getLookingPlayers();
        if (lookingPlayers.length > 0) {
            this.updateItems(lookingPlayers);
        }
    }

    public void saveAdditional(CompoundTag compound) {
        super.saveAdditional(compound);
        compound.put("items", (Tag)this.items.serializeNBT());
        compound.put("requests", (Tag)Utility.serializeAll(this.existingRequests));
    }

    public void load(CompoundTag compound) {
        this.items.deserializeNBT(compound.getCompound("items"));
        this.existingRequests.clear();
        this.existingRequests.addAll(Utility.deserializeAll(compound.getList("requests", 10), NetworkLock::new));
        super.load(compound);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.prettypipes.item_terminal");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int window, Inventory inv, Player player) {
        return new ItemTerminalContainer(Registry.itemTerminalContainer, window, player, this.worldPosition);
    }

    @Override
    public ConnectionType getConnectionType(BlockPos pipePos, Direction direction) {
        return ConnectionType.CONNECTED;
    }

    @Override
    public ItemStack insertItem(BlockPos pipePos, Direction direction, ItemStack stack, boolean simulate) {
        BlockPos pos = pipePos.relative(direction);
        ItemTerminalBlockEntity tile = Utility.getBlockEntity(ItemTerminalBlockEntity.class, (BlockGetter)this.level, pos);
        if (tile != null) {
            return ItemHandlerHelper.insertItemStacked((IItemHandler)tile.items, (ItemStack)stack, (boolean)simulate);
        }
        return stack;
    }

    @Override
    public boolean allowsModules(BlockPos pipePos, Direction direction) {
        return true;
    }

    public static Pair<List<NetworkLock>, ItemStack> requestItemLater(Level world, BlockPos destPipe, Collection<NetworkLocation> locations, Consumer<ItemStack> unavailableConsumer, ItemStack stack, Stack<ItemStack> dependencyChain, ItemEquality ... equalityTypes) {
        ArrayList<NetworkLock> requests = new ArrayList<NetworkLock>();
        ItemStack remain = stack.copy();
        PipeNetwork network = PipeNetwork.get(world);
        for (NetworkLocation location : locations) {
            int amount = location.getItemAmount(world, stack, equalityTypes);
            if (amount <= 0 || (amount -= network.getLockedAmount(location.getPos(), stack, null, equalityTypes)) <= 0) continue;
            if (remain.getCount() < amount) {
                amount = remain.getCount();
            }
            remain.shrink(amount);
            while (amount > 0) {
                ItemStack copy = stack.copy();
                copy.setCount(Math.min(stack.getMaxStackSize(), amount));
                NetworkLock lock = new NetworkLock(location, copy);
                network.createNetworkLock(lock);
                requests.add(lock);
                amount -= copy.getCount();
            }
            if (!remain.isEmpty()) continue;
            break;
        }
        if (!remain.isEmpty()) {
            remain = network.requestCraftedItem(destPipe, unavailableConsumer, remain, dependencyChain, equalityTypes);
        }
        return Pair.of(requests, (Object)remain);
    }

    public static Consumer<ItemStack> onItemUnavailable(Player player, boolean ignore) {
        return s -> {
            if (ignore) {
                return;
            }
            player.sendSystemMessage((Component)Component.translatable((String)"info.prettypipes.not_found", (Object[])new Object[]{s.getHoverName()}).setStyle(Style.EMPTY.applyFormat(ChatFormatting.RED)));
        };
    }
}

