/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.terminal.containers;

import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.terminal.CraftingTerminalBlockEntity;
import de.ellpeck.prettypipes.terminal.containers.ItemTerminalContainer;
import de.ellpeck.prettypipes.terminal.containers.WrappedCraftingInventory;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import org.apache.commons.lang3.tuple.Pair;

public class CraftingTerminalContainer
extends ItemTerminalContainer {
    public CraftingContainer craftInventory;
    public ResultContainer craftResult;
    private final Player player;

    public CraftingTerminalContainer(@Nullable MenuType<?> type, int id, Player player, BlockPos pos) {
        super(type, id, player, pos);
        this.player = player;
        this.slotsChanged((Container)this.craftInventory);
    }

    @Override
    protected void addOwnSlots(Player player) {
        this.craftInventory = new WrappedCraftingInventory(this.getTile().craftItems, this, 3, 3);
        this.craftResult = new ResultContainer(){

            public void setChanged() {
                for (Player player : CraftingTerminalContainer.this.getTile().getLookingPlayers()) {
                    player.containerMenu.slotsChanged((Container)this);
                }
            }
        };
        this.addSlot((Slot)new ResultSlot(player, this.craftInventory, (Container)this.craftResult, 0, 25, 77));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.addSlot(new Slot((Container)this.craftInventory, j + i * 3, 7 + j * 18, 18 + i * 18));
            }
        }
        super.addOwnSlots(player);
    }

    public void slotsChanged(Container inventoryIn) {
        super.slotsChanged(inventoryIn);
        if (!this.player.level().isClientSide) {
            ItemStack ret = ItemStack.EMPTY;
            Optional optional = this.player.level().getServer().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (Container)this.craftInventory, this.player.level());
            if (optional.isPresent()) {
                ret = ((CraftingRecipe)((RecipeHolder)optional.get()).value()).assemble((Container)this.craftInventory, this.player.level().registryAccess());
            }
            this.craftResult.setItem(0, ret);
            ((ServerPlayer)this.player).connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, 0, 0, ret));
        }
    }

    @Override
    public ItemStack quickMoveStack(Player player, int slotIndex) {
        return Utility.transferStackInSlot(this, (x$0, x$1, x$2, x$3) -> this.moveItemStackTo(x$0, x$1, x$2, x$3), player, slotIndex, stack -> Pair.of((Object)16, (Object)22));
    }

    @Override
    protected int getSlotXOffset() {
        return 65;
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId > 0 && clickTypeIn == ClickType.PICKUP) {
            Slot slot = (Slot)this.slots.get(slotId);
            if (slot.container == this.craftInventory && !slot.hasItem()) {
                this.getTile().ghostItems.setStackInSlot(slot.getSlotIndex(), ItemStack.EMPTY);
            }
        }
        super.clicked(slotId, dragType, clickTypeIn, player);
    }

    public CraftingTerminalBlockEntity getTile() {
        return (CraftingTerminalBlockEntity)this.tile;
    }
}

