/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.terminal.containers;

import com.mojang.blaze3d.platform.InputConstants;
import de.ellpeck.prettypipes.packets.PacketButton;
import de.ellpeck.prettypipes.terminal.CraftingTerminalBlockEntity;
import de.ellpeck.prettypipes.terminal.containers.CraftingTerminalContainer;
import de.ellpeck.prettypipes.terminal.containers.ItemTerminalContainer;
import de.ellpeck.prettypipes.terminal.containers.ItemTerminalGui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class CraftingTerminalGui
extends ItemTerminalGui {
    private static final ResourceLocation TEXTURE = new ResourceLocation("prettypipes", "textures/gui/crafting_terminal.png");
    private Button requestButton;

    public CraftingTerminalGui(ItemTerminalContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.imageWidth = 256;
    }

    @Override
    protected void init() {
        super.init();
        this.requestButton = this.addRenderableWidget(Button.builder((Component)Component.translatable((String)"info.prettypipes.request"), button -> {
            int amount = ItemTerminalGui.requestModifier();
            int force = Screen.hasAltDown() || InputConstants.isKeyDown((long)this.minecraft.getWindow().getWindow(), (int)259) ? 1 : 0;
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new PacketButton(((ItemTerminalContainer)this.menu).tile.getBlockPos(), PacketButton.ButtonResult.CRAFT_TERMINAL_REQUEST, amount, force)});
        }).bounds(this.leftPos + 8, this.topPos + 100, 50, 20).build());
        this.tick();
    }

    @Override
    public void containerTick() {
        super.containerTick();
        CraftingTerminalBlockEntity tile = this.getCraftingContainer().getTile();
        this.requestButton.active = false;
        for (int i = 0; i < tile.craftItems.getSlots(); ++i) {
            ItemStack stack = tile.getRequestedCraftItem(i);
            if (stack.isEmpty() || stack.getCount() >= stack.getMaxStackSize()) continue;
            this.requestButton.active = true;
            break;
        }
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderLabels(graphics, mouseX, mouseY);
        CraftingTerminalContainer container = this.getCraftingContainer();
        CraftingTerminalBlockEntity tile = container.getTile();
        for (int i = 0; i < tile.ghostItems.getSlots(); ++i) {
            ItemStack ghost;
            if (!tile.craftItems.getStackInSlot(i).isEmpty() || (ghost = tile.ghostItems.getStackInSlot(i)).isEmpty()) continue;
            int finalI = i;
            Slot slot = container.slots.stream().filter(s -> s.container == container.craftInventory && s.getSlotIndex() == finalI).findFirst().orElse(null);
            if (slot == null) continue;
            graphics.renderItem(ghost, slot.x, slot.y);
            graphics.renderItemDecorations(this.font, ghost, slot.x, slot.y, "0");
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE;
    }

    @Override
    protected int getXOffset() {
        return 65;
    }

    protected CraftingTerminalContainer getCraftingContainer() {
        return (CraftingTerminalContainer)this.menu;
    }
}

