/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.terminal.containers;

import com.mojang.blaze3d.platform.InputConstants;
import de.ellpeck.prettypipes.misc.ItemTerminalWidget;
import de.ellpeck.prettypipes.misc.PlayerPrefs;
import de.ellpeck.prettypipes.packets.PacketButton;
import de.ellpeck.prettypipes.packets.PacketRequest;
import de.ellpeck.prettypipes.terminal.containers.ItemTerminalContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import joptsimple.internal.Strings;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Pair;

public class ItemTerminalGui
extends AbstractContainerScreen<ItemTerminalContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("prettypipes", "textures/gui/item_terminal.png");
    public List<ItemStack> currentlyCrafting;
    public EditBox search;
    private final List<Pair<ItemStack, Boolean>> sortedItems = new ArrayList<Pair<ItemStack, Boolean>>();
    private List<ItemStack> items;
    private List<ItemStack> craftables;
    private Button minusButton;
    private Button plusButton;
    private Button requestButton;
    private Button orderButton;
    private Button ascendingButton;
    private Button cancelCraftingButton;
    private String lastSearchText;
    private int requestAmount = 1;
    private int scrollOffset;
    private ItemStack hoveredCrafting;
    private boolean isScrolling;

    public ItemTerminalGui(ItemTerminalContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.imageWidth = 191;
        this.imageHeight = 236;
    }

    protected void init() {
        super.init();
        this.search = this.addRenderableWidget(new EditBox(this.font, this.leftPos + this.getXOffset() + 97, this.topPos + 6, 86, 8, (Component)Component.literal((String)"")));
        this.search.setBordered(false);
        this.lastSearchText = "";
        if (this.items != null) {
            this.updateWidgets();
        }
        this.plusButton = this.addRenderableWidget(Button.builder((Component)Component.literal((String)"+"), button -> {
            int modifier = ItemTerminalGui.requestModifier();
            this.requestAmount = modifier > 1 && this.requestAmount == 1 ? modifier : (this.requestAmount += modifier);
            if (this.requestAmount > 384) {
                this.requestAmount = 384;
            }
        }).bounds(this.leftPos + this.getXOffset() + 95 - 7 + 12, this.topPos + 103, 12, 12).build());
        this.minusButton = this.addRenderableWidget(Button.builder((Component)Component.literal((String)"-"), button -> {
            this.requestAmount -= ItemTerminalGui.requestModifier();
            if (this.requestAmount < 1) {
                this.requestAmount = 1;
            }
        }).bounds(this.leftPos + this.getXOffset() + 95 - 7 - 24, this.topPos + 103, 12, 12).build());
        this.minusButton.active = false;
        this.requestButton = this.addRenderableWidget(Button.builder((Component)Component.translatable((String)"info.prettypipes.request"), button -> {
            Optional<ItemTerminalWidget> widget = this.streamWidgets().filter(w -> w.selected).findFirst();
            if (!widget.isPresent()) {
                return;
            }
            ItemStack stack = widget.get().stack.copy();
            stack.setCount(1);
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new PacketRequest(((ItemTerminalContainer)this.menu).tile.getBlockPos(), stack, this.requestAmount)});
            this.requestAmount = 1;
        }).bounds(this.leftPos + this.getXOffset() + 95 - 7 - 25, this.topPos + 115, 50, 20).build());
        this.requestButton.active = false;
        this.orderButton = this.addRenderableWidget(Button.builder((Component)Component.literal((String)""), button -> {
            if (this.sortedItems == null) {
                return;
            }
            PlayerPrefs prefs = PlayerPrefs.get();
            prefs.terminalItemOrder = prefs.terminalItemOrder.next();
            prefs.save();
            this.updateWidgets();
        }).bounds(this.leftPos - 22, this.topPos, 20, 20).build());
        this.ascendingButton = this.addRenderableWidget(Button.builder((Component)Component.literal((String)""), button -> {
            if (this.sortedItems == null) {
                return;
            }
            PlayerPrefs prefs = PlayerPrefs.get();
            prefs.terminalAscending = !prefs.terminalAscending;
            prefs.save();
            this.updateWidgets();
        }).bounds(this.leftPos - 22, this.topPos + 22, 20, 20).build());
        this.cancelCraftingButton = this.addRenderableWidget(Button.builder((Component)Component.translatable((String)"info.prettypipes.cancel_all"), b -> {}).bounds(this.leftPos + this.imageWidth + 4, this.topPos + 4 + 64, 54, 20).build());
        this.cancelCraftingButton.visible = false;
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addRenderableWidget(new ItemTerminalWidget(this.leftPos + this.getXOffset() + 8 + x * 18, this.topPos + 18 + y * 18, x, y, this));
            }
        }
    }

    protected int getXOffset() {
        return 0;
    }

    public void containerTick() {
        String text;
        super.containerTick();
        this.requestButton.active = this.streamWidgets().anyMatch(w -> w.selected);
        this.plusButton.active = this.requestAmount < 384;
        boolean bl = this.minusButton.active = this.requestAmount > 1;
        if (this.items != null && !this.lastSearchText.equals(text = this.search.getValue())) {
            this.lastSearchText = text;
            this.updateWidgets();
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && mouseX >= (double)(this.leftPos + this.getXOffset() + 172) && (double)this.topPos + mouseY >= 18.0 && mouseX < (double)(this.leftPos + this.getXOffset() + 172 + 12) && mouseY < (double)(this.topPos + 18 + 70)) {
            this.isScrolling = true;
            return true;
        }
        if (button == 1 && mouseX >= (double)this.search.getX() && mouseX <= (double)(this.search.getX() + this.search.getWidth()) && mouseY >= (double)this.search.getY() && mouseY <= (double)(this.search.getY() + 8)) {
            this.search.setValue("");
            this.search.setFocused(true);
            this.setFocused((GuiEventListener)this.search);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0 && this.cancelCraftingButton.visible && this.cancelCraftingButton.isHovered() && this.currentlyCrafting != null && !this.currentlyCrafting.isEmpty()) {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new PacketButton(((ItemTerminalContainer)this.menu).tile.getBlockPos(), PacketButton.ButtonResult.CANCEL_CRAFTING, new int[0])});
            return true;
        }
        if (button == 0) {
            this.isScrolling = false;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int i, double j, double k) {
        if (this.isScrolling) {
            float percentage = Mth.clamp((float)(((float)mouseY - (float)(this.topPos + 18) - 7.5f) / 55.0f), (float)0.0f, (float)1.0f);
            int offset = (int)(percentage * (float)(this.sortedItems.size() / 9 - 3));
            if (offset != this.scrollOffset) {
                this.scrollOffset = offset;
                this.updateWidgets();
            }
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, i, j, k);
    }

    public boolean keyPressed(int x, int y, int z) {
        InputConstants.Key mouseKey;
        if (this.search.isFocused() && this.minecraft.options.keyInventory.isActiveAndMatches(mouseKey = InputConstants.getKey((int)x, (int)y))) {
            return false;
        }
        return super.keyPressed(x, y, z);
    }

    public void updateItemList(List<ItemStack> items, List<ItemStack> craftables, List<ItemStack> currentlyCrafting) {
        this.items = items;
        this.craftables = craftables;
        this.currentlyCrafting = currentlyCrafting;
        this.updateWidgets();
    }

    public void updateWidgets() {
        PlayerPrefs prefs = PlayerPrefs.get();
        this.ascendingButton.setMessage((Component)Component.literal((String)(prefs.terminalAscending ? "^" : "v")));
        this.orderButton.setMessage((Component)Component.literal((String)prefs.terminalItemOrder.name().substring(0, 1)));
        this.cancelCraftingButton.visible = this.currentlyCrafting != null && !this.currentlyCrafting.isEmpty();
        Comparator<ItemStack> comparator = prefs.terminalItemOrder.comparator;
        if (!prefs.terminalAscending) {
            comparator = comparator.reversed();
        }
        this.sortedItems.clear();
        for (ItemStack stack : this.items) {
            this.sortedItems.add((Pair<ItemStack, Boolean>)Pair.of((Object)stack, (Object)false));
        }
        for (ItemStack stack : this.craftables) {
            this.sortedItems.add((Pair<ItemStack, Boolean>)Pair.of((Object)stack, (Object)true));
        }
        Comparator<Pair> fullComparator = Comparator.comparing(Pair::getRight);
        this.sortedItems.sort(fullComparator.thenComparing(Pair::getLeft, comparator));
        String searchText = this.search.getValue();
        if (!Strings.isNullOrEmpty((String)searchText)) {
            this.sortedItems.removeIf(s -> {
                String toCompare;
                String search = searchText;
                if (search.startsWith("@")) {
                    toCompare = ((ItemStack)s.getLeft()).getItem().getCreatorModId((ItemStack)s.getLeft());
                    search = search.substring(1);
                } else if (search.startsWith("#")) {
                    List hoverText = ((ItemStack)s.getLeft()).getTooltipLines((Player)this.minecraft.player, (TooltipFlag)(this.minecraft.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
                    toCompare = hoverText.stream().map(Component::getString).collect(Collectors.joining("\n"));
                    search = search.substring(1);
                } else {
                    toCompare = ((ItemStack)s.getLeft()).getHoverName().getString();
                }
                return !toCompare.toLowerCase(Locale.ROOT).contains(search.toLowerCase(Locale.ROOT));
            });
        }
        if (this.sortedItems.size() < 36) {
            this.scrollOffset = 0;
        }
        List widgets = this.streamWidgets().collect(Collectors.toList());
        for (int i = 0; i < widgets.size(); ++i) {
            ItemTerminalWidget widget = (ItemTerminalWidget)((Object)widgets.get(i));
            int index = i + this.scrollOffset * 9;
            if (index >= this.sortedItems.size()) {
                widget.stack = ItemStack.EMPTY;
                widget.craftable = false;
                widget.visible = false;
                continue;
            }
            Pair<ItemStack, Boolean> stack = this.sortedItems.get(index);
            widget.stack = (ItemStack)stack.getLeft();
            widget.craftable = (Boolean)stack.getRight();
            widget.visible = true;
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        for (Renderable widget : this.renderables) {
            if (!(widget instanceof ItemTerminalWidget)) continue;
            ItemTerminalWidget terminal = (ItemTerminalWidget)widget;
            terminal.renderToolTip(graphics, mouseX, mouseY);
        }
        if (this.sortedItems != null) {
            PlayerPrefs prefs = PlayerPrefs.get();
            if (this.orderButton.isHovered()) {
                graphics.renderTooltip(this.font, (Component)Component.translatable((String)"info.prettypipes.order", (Object[])new Object[]{I18n.get((String)("info.prettypipes.order." + prefs.terminalItemOrder.name().toLowerCase(Locale.ROOT)), (Object[])new Object[0])}), mouseX, mouseY);
            }
            if (this.ascendingButton.isHovered()) {
                graphics.renderTooltip(this.font, (Component)Component.translatable((String)("info.prettypipes." + (prefs.terminalAscending ? "ascending" : "descending"))), mouseX, mouseY);
            }
        }
        if (this.cancelCraftingButton.visible && this.cancelCraftingButton.isHovered()) {
            String[] tooltip = I18n.get((String)"info.prettypipes.cancel_all.desc", (Object[])new Object[0]).split("\n");
            graphics.renderTooltip(this.font, Arrays.stream(tooltip).map(Component::literal).collect(Collectors.toList()), Optional.empty(), mouseX, mouseY);
        }
        if (!this.hoveredCrafting.isEmpty()) {
            graphics.renderTooltip(this.font, this.hoveredCrafting, mouseX, mouseY);
        }
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.playerInventoryTitle.getString(), 8 + this.getXOffset(), this.imageHeight - 96 + 2, 0x404040, false);
        graphics.drawString(this.font, this.title.getString(), 8, 6, 0x404040, false);
        String amount = String.valueOf(this.requestAmount);
        graphics.drawString(this.font, amount, (191 - this.font.width(amount)) / 2 - 7 + this.getXOffset(), 106, 0x404040, false);
        if (this.currentlyCrafting != null && !this.currentlyCrafting.isEmpty()) {
            graphics.drawString(this.font, I18n.get((String)"info.prettypipes.crafting", (Object[])new Object[0]), this.imageWidth + 4, 10, 0x404040, false);
            if (this.currentlyCrafting.size() > 6) {
                graphics.drawString(this.font, ". . .", this.imageWidth + 24, 55, 0x404040, false);
            }
        }
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.blit(this.getTexture(), this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        if (this.sortedItems != null && this.sortedItems.size() >= 36) {
            float percentage = (float)this.scrollOffset / (float)(this.sortedItems.size() / 9 - 3);
            graphics.blit(this.getTexture(), this.leftPos + this.getXOffset() + 172, this.topPos + 18 + (int)(percentage * 55.0f), 232, 241, 12, 15);
        } else {
            graphics.blit(this.getTexture(), this.leftPos + this.getXOffset() + 172, this.topPos + 18, 244, 241, 12, 15);
        }
        this.hoveredCrafting = ItemStack.EMPTY;
        if (this.currentlyCrafting != null && !this.currentlyCrafting.isEmpty()) {
            graphics.blit(TEXTURE, this.leftPos + this.imageWidth, this.topPos + 4, 191, 0, 65, 89);
            int x = 0;
            int y = 0;
            for (ItemStack stack : this.currentlyCrafting) {
                int itemX = this.leftPos + this.imageWidth + 4 + x * 18;
                int itemY = this.topPos + 4 + 16 + y * 18;
                graphics.renderItem(stack, itemX, itemY);
                graphics.renderItemDecorations(this.font, stack, itemX, itemY, String.valueOf(stack.getCount()));
                if (mouseX >= itemX && mouseY >= itemY && mouseX < itemX + 16 && mouseY < itemY + 18) {
                    this.hoveredCrafting = stack;
                }
                if (++x < 3) continue;
                x = 0;
                if (++y < 2) continue;
                break;
            }
        }
    }

    protected ResourceLocation getTexture() {
        return TEXTURE;
    }

    public boolean mouseScrolled(double x, double y, double scrollX, double scrollY) {
        int offset;
        if (this.sortedItems != null && this.sortedItems.size() >= 36 && (offset = Mth.clamp((int)(this.scrollOffset - (int)Math.signum(scrollY)), (int)0, (int)(this.sortedItems.size() / 9 - 3))) != this.scrollOffset) {
            this.scrollOffset = offset;
            this.updateWidgets();
        }
        return true;
    }

    public <T extends GuiEventListener & Renderable> T addRenderableWidget(T p_169406_) {
        return (T)super.addRenderableWidget(p_169406_);
    }

    public Stream<ItemTerminalWidget> streamWidgets() {
        return this.renderables.stream().filter(w -> w instanceof ItemTerminalWidget).map(w -> (ItemTerminalWidget)((Object)w));
    }

    public static int requestModifier() {
        if (Screen.hasControlDown()) {
            return 10;
        }
        if (Screen.hasShiftDown()) {
            return 64;
        }
        return 1;
    }
}

