/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.block.entity;

import java.util.Set;
import net.darkhax.bookshelf.api.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class InventoryBlockEntity<T extends Container>
extends BaseContainerBlockEntity {
    private final T inventory = this.createInventory();

    public InventoryBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public final T getInventory() {
        return this.inventory;
    }

    public abstract T createInventory();

    public void dropContents(BlockState state, Level world, BlockPos pos) {
        Containers.dropContents((Level)world, (BlockPos)pos, this.getInventory());
    }

    public void readInventory(CompoundTag tag) {
        NonNullList tempInvStacks = NonNullList.withSize((int)this.getInventory().getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)tempInvStacks);
        Services.INVENTORY_HELPER.fill((Container)this.getInventory(), (NonNullList<ItemStack>)tempInvStacks);
    }

    public CompoundTag saveInventory() {
        return ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), Services.INVENTORY_HELPER.toList((Container)this.getInventory()));
    }

    public void markDirty() {
        super.setChanged();
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        if (tag.contains("Inventory", 10)) {
            this.readInventory(tag.getCompound("Inventory"));
        }
    }

    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.put("Inventory", (Tag)this.saveInventory());
    }

    protected AbstractContainerMenu createMenu(int i, Inventory inventory) {
        return null;
    }

    public final int getContainerSize() {
        return this.getInventory().getContainerSize();
    }

    public final boolean isEmpty() {
        return this.getInventory().isEmpty();
    }

    public final ItemStack getItem(int slot) {
        return this.getInventory().getItem(slot);
    }

    public final ItemStack removeItem(int slot, int amount) {
        return this.getInventory().removeItem(slot, amount);
    }

    public final ItemStack removeItemNoUpdate(int slot) {
        return this.getInventory().removeItemNoUpdate(slot);
    }

    public final void setItem(int slot, ItemStack stack) {
        this.getInventory().setItem(slot, stack);
    }

    public final int getMaxStackSize() {
        return this.getInventory().getMaxStackSize();
    }

    public final void setChanged() {
        super.setChanged();
        this.getInventory().setChanged();
    }

    public final boolean stillValid(Player player) {
        return this.getInventory().stillValid(player);
    }

    public final void startOpen(Player player) {
        this.getInventory().startOpen(player);
    }

    public final void stopOpen(Player player) {
        this.getInventory().stopOpen(player);
    }

    public final boolean canPlaceItem(int slot, ItemStack stack) {
        return this.getInventory().canPlaceItem(slot, stack);
    }

    public final int countItem(Item toCount) {
        return this.getInventory().countItem(toCount);
    }

    public final boolean hasAnyOf(Set<Item> toFind) {
        return this.getInventory().hasAnyOf(toFind);
    }

    public final void clearContent() {
        this.getInventory().clearContent();
    }
}

