/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.data.bytebuf;

import net.darkhax.bookshelf.api.data.bytebuf.ByteBufHelper;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public class RegistryByteBufHelper<T>
extends ByteBufHelper<T> {
    private final Registry<T> registry;
    private final ByteBufHelper<TagKey<T>> tagHelper;

    public RegistryByteBufHelper(Registry<T> registry) {
        super(buffer -> {
            ResourceLocation id = buffer.readResourceLocation();
            return registry.containsKey(id) ? registry.get(id) : null;
        }, (buffer, entry) -> buffer.writeResourceLocation(registry.getKey(entry)), new Object[0]);
        this.registry = registry;
        this.tagHelper = new ByteBufHelper<TagKey>(buffer -> TagKey.create((ResourceKey)registry.key(), (ResourceLocation)buffer.readResourceLocation()), (buffer, tag) -> buffer.writeResourceLocation(tag.location()), new TagKey[0]);
    }

    public ByteBufHelper<TagKey<T>> tag() {
        return this.tagHelper;
    }
}

